/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeFactory;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class NodeMap {
    NodeFactory nodeFact;
    Map nodeMap = new TreeMap();

    public NodeMap(NodeFactory nodeFactory) {
        this.nodeFact = nodeFactory;
    }

    public void add(EdgeEnd edgeEnd) {
        this.addNode(edgeEnd.getCoordinate()).add(edgeEnd);
    }

    public Node addNode(Coordinate coordinate) {
        Node node;
        Node node2 = node = (Node)this.nodeMap.get(coordinate);
        if (node == null) {
            node2 = this.nodeFact.createNode(coordinate);
            this.nodeMap.put(coordinate, node2);
        }
        return node2;
    }

    public Node addNode(Node node) {
        Node node2 = (Node)this.nodeMap.get(node.getCoordinate());
        if (node2 == null) {
            this.nodeMap.put(node.getCoordinate(), node);
            return node;
        }
        node2.mergeLabel(node);
        return node2;
    }

    public Node find(Coordinate coordinate) {
        return (Node)this.nodeMap.get(coordinate);
    }

    public Collection getBoundaryNodes(int n) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            if (node.getLabel().getLocation(n) != 1) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    public void print(PrintStream printStream) {
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            ((Node)iterator2.next()).print(printStream);
        }
        return;
    }

    public Collection values() {
        return this.nodeMap.values();
    }
}

