/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeFactory;
import com.vividsolutions.jts.geomgraph.NodeMap;
import com.vividsolutions.jts.geomgraph.Quadrant;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PlanarGraph {
    protected List edgeEndList;
    protected List edges = new ArrayList();
    protected NodeMap nodes;

    public PlanarGraph() {
        this.edgeEndList = new ArrayList();
        this.nodes = new NodeMap(new NodeFactory());
    }

    public PlanarGraph(NodeFactory nodeFactory) {
        this.edgeEndList = new ArrayList();
        this.nodes = new NodeMap(nodeFactory);
    }

    public static void linkResultDirectedEdges(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            ((DirectedEdgeStar)((Node)object.next()).getEdges()).linkResultDirectedEdges();
        }
        return;
    }

    private boolean matchInSameDirection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        if (!coordinate.equals(coordinate3)) {
            return false;
        }
        return CGAlgorithms.computeOrientation(coordinate, coordinate2, coordinate4) == 0 && Quadrant.quadrant(coordinate, coordinate2) == Quadrant.quadrant(coordinate3, coordinate4);
    }

    public void add(EdgeEnd edgeEnd) {
        this.nodes.add(edgeEnd);
        this.edgeEndList.add(edgeEnd);
    }

    public void addEdges(List object) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Edge)object.next();
            this.edges.add(object2);
            DirectedEdge directedEdge = new DirectedEdge((Edge)object2, true);
            object2 = new DirectedEdge((Edge)object2, false);
            directedEdge.setSym((DirectedEdge)object2);
            ((DirectedEdge)object2).setSym(directedEdge);
            this.add(directedEdge);
            this.add((EdgeEnd)object2);
        }
        return;
    }

    public Node addNode(Coordinate coordinate) {
        return this.nodes.addNode(coordinate);
    }

    public Node addNode(Node node) {
        return this.nodes.addNode(node);
    }

    void debugPrint(Object object) {
        System.out.print(object);
    }

    void debugPrintln(Object object) {
        System.out.println(object);
    }

    public Node find(Coordinate coordinate) {
        return this.nodes.find(coordinate);
    }

    public Edge findEdge(Coordinate coordinate, Coordinate coordinate2) {
        int n = 0;
        while (n < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(n);
            Coordinate[] coordinateArray = edge.getCoordinates();
            if (coordinate.equals(coordinateArray[0]) && coordinate2.equals(coordinateArray[1])) {
                return edge;
            }
            ++n;
        }
        return null;
    }

    public EdgeEnd findEdgeEnd(Edge edge) {
        EdgeEnd edgeEnd;
        Iterator iterator2 = this.getEdgeEnds().iterator();
        do {
            if (iterator2.hasNext()) continue;
            return null;
        } while ((edgeEnd = (EdgeEnd)iterator2.next()).getEdge() != edge);
        return edgeEnd;
    }

    public Edge findEdgeInSameDirection(Coordinate coordinate, Coordinate coordinate2) {
        int n = 0;
        while (n < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(n);
            Coordinate[] coordinateArray = edge.getCoordinates();
            if (this.matchInSameDirection(coordinate, coordinate2, coordinateArray[0], coordinateArray[1])) {
                return edge;
            }
            if (this.matchInSameDirection(coordinate, coordinate2, coordinateArray[coordinateArray.length - 1], coordinateArray[coordinateArray.length - 2])) {
                return edge;
            }
            ++n;
        }
        return null;
    }

    public Collection getEdgeEnds() {
        return this.edgeEndList;
    }

    public Iterator getEdgeIterator() {
        return this.edges.iterator();
    }

    public Iterator getNodeIterator() {
        return this.nodes.iterator();
    }

    public Collection getNodes() {
        return this.nodes.values();
    }

    protected void insertEdge(Edge edge) {
        this.edges.add(edge);
    }

    public boolean isBoundaryNode(int n, Coordinate object) {
        if ((object = this.nodes.find((Coordinate)object)) == null) {
            return false;
        }
        return (object = ((GraphComponent)object).getLabel()) != null && ((Label)object).getLocation(n) == 1;
    }

    public void linkAllDirectedEdges() {
        Iterator iterator2 = this.nodes.iterator();
        while (iterator2.hasNext()) {
            ((DirectedEdgeStar)((Node)iterator2.next()).getEdges()).linkAllDirectedEdges();
        }
        return;
    }

    public void linkResultDirectedEdges() {
        Iterator iterator2 = this.nodes.iterator();
        while (iterator2.hasNext()) {
            ((DirectedEdgeStar)((Node)iterator2.next()).getEdges()).linkResultDirectedEdges();
        }
        return;
    }

    public void printEdges(PrintStream printStream) {
        printStream.println("Edges:");
        int n = 0;
        while (n < this.edges.size()) {
            Object object = new StringBuilder("edge ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(":");
            printStream.println(((StringBuilder)object).toString());
            object = (Edge)this.edges.get(n);
            ((Edge)object).print(printStream);
            ((Edge)object).eiList.print(printStream);
            ++n;
        }
        return;
    }
}

