/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.index.MonotoneChainIndexer;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;

public class MonotoneChainEdge {
    Edge e;
    Envelope env1 = new Envelope();
    Envelope env2 = new Envelope();
    Coordinate[] pts;
    int[] startIndex;

    public MonotoneChainEdge(Edge edge) {
        this.e = edge;
        this.pts = edge.getCoordinates();
        this.startIndex = new MonotoneChainIndexer().getChainStartIndices(this.pts);
    }

    private void computeIntersectsForChain(int n, int n2, MonotoneChainEdge monotoneChainEdge, int n3, int n4, SegmentIntersector segmentIntersector) {
        Object object = this.pts;
        Coordinate coordinate = object[n];
        object = object[n2];
        Object object2 = monotoneChainEdge.pts;
        Coordinate coordinate2 = object2[n3];
        object2 = object2[n4];
        if (n2 - n == 1 && n4 - n3 == 1) {
            segmentIntersector.addIntersections(this.e, n, monotoneChainEdge.e, n3);
            return;
        }
        this.env1.init(coordinate, (Coordinate)object);
        this.env2.init(coordinate2, (Coordinate)object2);
        if (!this.env1.intersects(this.env2)) {
            return;
        }
        int n5 = (n + n2) / 2;
        int n6 = (n3 + n4) / 2;
        if (n < n5) {
            if (n3 < n6) {
                this.computeIntersectsForChain(n, n5, monotoneChainEdge, n3, n6, segmentIntersector);
            }
            if (n6 < n4) {
                this.computeIntersectsForChain(n, n5, monotoneChainEdge, n6, n4, segmentIntersector);
            }
        }
        if (n5 < n2) {
            if (n3 < n6) {
                this.computeIntersectsForChain(n5, n2, monotoneChainEdge, n3, n6, segmentIntersector);
            }
            if (n6 < n4) {
                this.computeIntersectsForChain(n5, n2, monotoneChainEdge, n6, n4, segmentIntersector);
            }
        }
    }

    public void computeIntersects(MonotoneChainEdge monotoneChainEdge, SegmentIntersector segmentIntersector) {
        int n = 0;
        block0: while (n < this.startIndex.length - 1) {
            int n2 = 0;
            while (true) {
                if (n2 >= monotoneChainEdge.startIndex.length - 1) {
                    ++n;
                    continue block0;
                }
                this.computeIntersectsForChain(n, monotoneChainEdge, n2, segmentIntersector);
                ++n2;
            }
            break;
        }
        return;
    }

    public void computeIntersectsForChain(int n, MonotoneChainEdge monotoneChainEdge, int n2, SegmentIntersector segmentIntersector) {
        int[] nArray = this.startIndex;
        int n3 = nArray[n];
        n = nArray[n + 1];
        nArray = monotoneChainEdge.startIndex;
        this.computeIntersectsForChain(n3, n, monotoneChainEdge, nArray[n2], nArray[n2 + 1], segmentIntersector);
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public double getMaxX(int n) {
        double d = this.pts[this.startIndex[n]].x;
        double d2 = this.pts[this.startIndex[n + 1]].x;
        if (!(d > d2)) {
            d = d2;
        }
        return d;
    }

    public double getMinX(int n) {
        double d = this.pts[this.startIndex[n]].x;
        double d2 = this.pts[this.startIndex[n + 1]].x;
        if (!(d < d2)) {
            d = d2;
        }
        return d;
    }

    public int[] getStartIndexes() {
        return this.startIndex;
    }
}

