/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

import com.vividsolutions.jts.index.bintree.Interval;
import com.vividsolutions.jts.index.bintree.Root;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Bintree {
    private double minExtent = 1.0;
    private Root root = new Root();

    private void collectStats(Interval interval) {
        double d = interval.getWidth();
        if (d < this.minExtent && d > 0.0) {
            this.minExtent = d;
        }
    }

    public static Interval ensureExtent(Interval interval, double d) {
        double d2;
        double d3 = interval.getMin();
        double d4 = d3 - (d2 = interval.getMax());
        double d5 = d4 == 0.0 ? 0 : (d4 > 0.0 ? 1 : -1);
        if (d5 != false) {
            return interval;
        }
        double d6 = d3;
        if (d5 == false) {
            d6 = d3 - (d /= 2.0);
            d2 = d6 + d;
        }
        return new Interval(d6, d2);
    }

    public int depth() {
        Root root = this.root;
        if (root != null) {
            return root.depth();
        }
        return 0;
    }

    public void insert(Interval interval, Object object) {
        this.collectStats(interval);
        interval = Bintree.ensureExtent(interval, this.minExtent);
        this.root.insert(interval, object);
    }

    public Iterator iterator() {
        ArrayList arrayList = new ArrayList();
        this.root.addAllItems(arrayList);
        return arrayList.iterator();
    }

    public int nodeSize() {
        Root root = this.root;
        if (root != null) {
            return root.nodeSize();
        }
        return 0;
    }

    public List query(double d) {
        return this.query(new Interval(d, d));
    }

    public List query(Interval interval) {
        ArrayList arrayList = new ArrayList();
        this.query(interval, arrayList);
        return arrayList;
    }

    public void query(Interval interval, Collection collection) {
        this.root.addAllItemsFromOverlapping(interval, collection);
    }

    public boolean remove(Interval interval, Object object) {
        interval = Bintree.ensureExtent(interval, this.minExtent);
        return this.root.remove(interval, object);
    }

    public int size() {
        Root root = this.root;
        if (root != null) {
            return root.size();
        }
        return 0;
    }
}

