/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

public class Interval {
    public double max;
    public double min;

    public Interval() {
        this.min = 0.0;
        this.max = 0.0;
    }

    public Interval(double d, double d2) {
        this.init(d, d2);
    }

    public Interval(Interval interval) {
        this.init(interval.min, interval.max);
    }

    public boolean contains(double d) {
        return d >= this.min && d <= this.max;
    }

    public boolean contains(double d, double d2) {
        return d >= this.min && d2 <= this.max;
    }

    public boolean contains(Interval interval) {
        return this.contains(interval.min, interval.max);
    }

    public void expandToInclude(Interval interval) {
        double d = interval.max;
        if (d > this.max) {
            this.max = d;
        }
        if ((d = interval.min) < this.min) {
            this.min = d;
        }
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getWidth() {
        return this.max - this.min;
    }

    public void init(double d, double d2) {
        this.min = d;
        this.max = d2;
        if (d > d2) {
            this.min = d2;
            this.max = d;
        }
    }

    public boolean overlaps(double d, double d2) {
        return !(this.min > d2) && !(this.max < d);
        {
        }
    }

    public boolean overlaps(Interval interval) {
        return this.overlaps(interval.min, interval.max);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append(this.min);
        stringBuilder.append(", ");
        stringBuilder.append(this.max);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

