/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

import com.vividsolutions.jts.index.bintree.Interval;
import com.vividsolutions.jts.index.quadtree.DoubleBits;

public class Key {
    private Interval interval;
    private int level = 0;
    private double pt = 0.0;

    public Key(Interval interval) {
        this.computeKey(interval);
    }

    private void computeInterval(int n, Interval interval) {
        double d;
        double d2 = DoubleBits.powerOf2(n);
        this.pt = d = Math.floor(interval.getMin() / d2) * d2;
        this.interval.init(d, d2 + d);
    }

    public static int computeLevel(Interval interval) {
        return DoubleBits.exponent(interval.getWidth()) + 1;
    }

    public void computeKey(Interval interval) {
        this.level = Key.computeLevel(interval);
        this.interval = new Interval();
        this.computeInterval(this.level, interval);
        while (!this.interval.contains(interval)) {
            int n;
            this.level = n = this.level + 1;
            this.computeInterval(n, interval);
        }
        return;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public int getLevel() {
        return this.level;
    }

    public double getPoint() {
        return this.pt;
    }
}

