/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

import com.vividsolutions.jts.index.bintree.Interval;
import com.vividsolutions.jts.index.bintree.Key;
import com.vividsolutions.jts.index.bintree.NodeBase;
import com.vividsolutions.jts.util.Assert;

public class Node
extends NodeBase {
    private double centre;
    private Interval interval;
    private int level;

    public Node(Interval interval, int n) {
        this.interval = interval;
        this.level = n;
        this.centre = (interval.getMin() + interval.getMax()) / 2.0;
    }

    public static Node createExpanded(Node node, Interval object) {
        object = new Interval((Interval)object);
        if (node != null) {
            ((Interval)object).expandToInclude(node.interval);
        }
        object = Node.createNode((Interval)object);
        if (node != null) {
            ((Node)object).insert(node);
        }
        return object;
    }

    public static Node createNode(Interval object) {
        object = new Key((Interval)object);
        return new Node(((Key)object).getInterval(), ((Key)object).getLevel());
    }

    private Node createSubnode(int n) {
        double d;
        double d2 = 0.0;
        if (n != 0) {
            if (n != 1) {
                d = 0.0;
            } else {
                d2 = this.centre;
                d = this.interval.getMax();
            }
        } else {
            d2 = this.interval.getMin();
            d = this.centre;
        }
        return new Node(new Interval(d2, d), this.level - 1);
    }

    private Node getSubnode(int n) {
        if (this.subnode[n] == null) {
            this.subnode[n] = this.createSubnode(n);
        }
        return this.subnode[n];
    }

    public NodeBase find(Interval interval) {
        int n = Node.getSubnodeIndex(interval, this.centre);
        if (n == -1) {
            return this;
        }
        if (this.subnode[n] != null) {
            return this.subnode[n].find(interval);
        }
        return this;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public Node getNode(Interval interval) {
        int n = Node.getSubnodeIndex(interval, this.centre);
        if (n != -1) {
            return this.getSubnode(n).getNode(interval);
        }
        return this;
    }

    void insert(Node node) {
        Object object = this.interval;
        boolean bl = object == null || ((Interval)object).contains(node.interval);
        Assert.isTrue(bl);
        int n = Node.getSubnodeIndex(node.interval, this.centre);
        if (node.level == this.level - 1) {
            this.subnode[n] = node;
        } else {
            object = this.createSubnode(n);
            ((Node)object).insert(node);
            this.subnode[n] = object;
        }
    }

    @Override
    protected boolean isSearchMatch(Interval interval) {
        return interval.overlaps(this.interval);
    }
}

