/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.chain;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.index.chain.MonotoneChainOverlapAction;
import com.vividsolutions.jts.index.chain.MonotoneChainSelectAction;

public class MonotoneChain {
    private Object context = null;
    private int end;
    private Envelope env = null;
    private int id;
    private Coordinate[] pts;
    private int start;

    public MonotoneChain(Coordinate[] coordinateArray, int n, int n2, Object object) {
        this.pts = coordinateArray;
        this.start = n;
        this.end = n2;
        this.context = object;
    }

    private void computeOverlaps(int n, int n2, MonotoneChain monotoneChain, int n3, int n4, MonotoneChainOverlapAction monotoneChainOverlapAction) {
        Object object = this.pts;
        Coordinate coordinate = object[n];
        object = object[n2];
        Object object2 = monotoneChain.pts;
        Coordinate coordinate2 = object2[n3];
        object2 = object2[n4];
        if (n2 - n == 1 && n4 - n3 == 1) {
            monotoneChainOverlapAction.overlap(this, n, monotoneChain, n3);
            return;
        }
        monotoneChainOverlapAction.tempEnv1.init(coordinate, (Coordinate)object);
        monotoneChainOverlapAction.tempEnv2.init(coordinate2, (Coordinate)object2);
        if (!monotoneChainOverlapAction.tempEnv1.intersects(monotoneChainOverlapAction.tempEnv2)) {
            return;
        }
        int n5 = (n + n2) / 2;
        int n6 = (n3 + n4) / 2;
        if (n < n5) {
            if (n3 < n6) {
                this.computeOverlaps(n, n5, monotoneChain, n3, n6, monotoneChainOverlapAction);
            }
            if (n6 < n4) {
                this.computeOverlaps(n, n5, monotoneChain, n6, n4, monotoneChainOverlapAction);
            }
        }
        if (n5 < n2) {
            if (n3 < n6) {
                this.computeOverlaps(n5, n2, monotoneChain, n3, n6, monotoneChainOverlapAction);
            }
            if (n6 < n4) {
                this.computeOverlaps(n5, n2, monotoneChain, n6, n4, monotoneChainOverlapAction);
            }
        }
    }

    private void computeSelect(Envelope envelope, int n, int n2, MonotoneChainSelectAction monotoneChainSelectAction) {
        Object object = this.pts;
        Coordinate coordinate = object[n];
        object = object[n2];
        monotoneChainSelectAction.tempEnv1.init(coordinate, (Coordinate)object);
        if (n2 - n == 1) {
            monotoneChainSelectAction.select(this, n);
            return;
        }
        if (!envelope.intersects(monotoneChainSelectAction.tempEnv1)) {
            return;
        }
        int n3 = (n + n2) / 2;
        if (n < n3) {
            this.computeSelect(envelope, n, n3, monotoneChainSelectAction);
        }
        if (n3 < n2) {
            this.computeSelect(envelope, n3, n2, monotoneChainSelectAction);
        }
    }

    public void computeOverlaps(MonotoneChain monotoneChain, MonotoneChainOverlapAction monotoneChainOverlapAction) {
        this.computeOverlaps(this.start, this.end, monotoneChain, monotoneChain.start, monotoneChain.end, monotoneChainOverlapAction);
    }

    public Object getContext() {
        return this.context;
    }

    public Coordinate[] getCoordinates() {
        int n = this.end;
        int n2 = this.start;
        Coordinate[] coordinateArray = new Coordinate[n - n2 + 1];
        n = 0;
        while (n2 <= this.end) {
            coordinateArray[n] = this.pts[n2];
            ++n2;
            ++n;
        }
        return coordinateArray;
    }

    public int getEndIndex() {
        return this.end;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            Coordinate[] coordinateArray = this.pts;
            this.env = new Envelope(coordinateArray[this.start], coordinateArray[this.end]);
        }
        return this.env;
    }

    public int getId() {
        return this.id;
    }

    public void getLineSegment(int n, LineSegment lineSegment) {
        lineSegment.p0 = this.pts[n];
        lineSegment.p1 = this.pts[n + 1];
    }

    public int getStartIndex() {
        return this.start;
    }

    public void select(Envelope envelope, MonotoneChainSelectAction monotoneChainSelectAction) {
        this.computeSelect(envelope, this.start, this.end, monotoneChainSelectAction);
    }

    public void setId(int n) {
        this.id = n;
    }
}

