/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.intervalrtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.io.WKTWriter;
import java.util.Comparator;

public abstract class IntervalRTreeNode {
    protected double max;
    protected double min = Double.POSITIVE_INFINITY;

    public IntervalRTreeNode() {
        this.max = Double.NEGATIVE_INFINITY;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    protected boolean intersects(double d, double d2) {
        return !(this.min > d2) && !(this.max < d);
        {
        }
    }

    public abstract void query(double var1, double var3, ItemVisitor var5);

    public String toString() {
        return WKTWriter.toLineString(new Coordinate(this.min, 0.0), new Coordinate(this.max, 0.0));
    }

    public static class NodeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            object = (IntervalRTreeNode)object;
            object2 = (IntervalRTreeNode)object2;
            double d = (((IntervalRTreeNode)object).min + ((IntervalRTreeNode)object).max) / 2.0;
            double d2 = (((IntervalRTreeNode)object2).min + ((IntervalRTreeNode)object2).max) / 2.0;
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            return 0;
        }
    }
}

