/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.intervalrtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.intervalrtree.IntervalRTreeBranchNode;
import com.vividsolutions.jts.index.intervalrtree.IntervalRTreeLeafNode;
import com.vividsolutions.jts.index.intervalrtree.IntervalRTreeNode;
import com.vividsolutions.jts.io.WKTWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SortedPackedIntervalRTree {
    private List leaves = new ArrayList();
    private int level = 0;
    private IntervalRTreeNode root = null;

    private void buildLevel(List list, List list2) {
        ++this.level;
        list2.clear();
        int n = 0;
        while (n < list.size()) {
            IntervalRTreeNode intervalRTreeNode = (IntervalRTreeNode)list.get(n);
            int n2 = n + 1;
            IntervalRTreeNode intervalRTreeNode2 = n2 < list.size() ? (IntervalRTreeNode)list.get(n) : null;
            if (intervalRTreeNode2 == null) {
                list2.add(intervalRTreeNode);
            } else {
                list2.add(new IntervalRTreeBranchNode((IntervalRTreeNode)list.get(n), (IntervalRTreeNode)list.get(n2)));
            }
            n += 2;
        }
        return;
    }

    private void buildRoot() {
        synchronized (this) {
            block4: {
                IntervalRTreeNode intervalRTreeNode = this.root;
                if (intervalRTreeNode == null) break block4;
                return;
            }
            this.root = this.buildTree();
            return;
        }
    }

    private IntervalRTreeNode buildTree() {
        Collections.sort(this.leaves, new IntervalRTreeNode.NodeComparator());
        ArrayList arrayList = this.leaves;
        ArrayList arrayList2 = new ArrayList();
        while (true) {
            ArrayList arrayList3 = arrayList2;
            this.buildLevel(arrayList, arrayList3);
            if (arrayList3.size() == 1) {
                return (IntervalRTreeNode)arrayList3.get(0);
            }
            arrayList2 = arrayList;
            arrayList = arrayList3;
        }
    }

    private void init() {
        if (this.root != null) {
            return;
        }
        this.buildRoot();
    }

    private void printNode(IntervalRTreeNode intervalRTreeNode) {
        System.out.println(WKTWriter.toLineString(new Coordinate(intervalRTreeNode.min, this.level), new Coordinate(intervalRTreeNode.max, this.level)));
    }

    public void insert(double d, double d2, Object object) {
        if (this.root == null) {
            this.leaves.add(new IntervalRTreeLeafNode(d, d2, object));
            return;
        }
        throw new IllegalStateException("Index cannot be added to once it has been queried");
    }

    public void query(double d, double d2, ItemVisitor itemVisitor) {
        this.init();
        this.root.query(d, d2, itemVisitor);
    }
}

