/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

public class DoubleBits {
    public static final int EXPONENT_BIAS = 1023;
    private double x;
    private long xBits;

    public DoubleBits(double d) {
        this.x = d;
        this.xBits = Double.doubleToLongBits(d);
    }

    public static int exponent(double d) {
        return new DoubleBits(d).getExponent();
    }

    public static double maximumCommonMantissa(double d, double d2) {
        if (d != 0.0 && d2 != 0.0) {
            DoubleBits doubleBits = new DoubleBits(d);
            DoubleBits doubleBits2 = new DoubleBits(d2);
            if (doubleBits.getExponent() != doubleBits2.getExponent()) {
                return 0.0;
            }
            doubleBits.zeroLowerBits(64 - (doubleBits.numCommonMantissaBits(doubleBits2) + 12));
            return doubleBits.getDouble();
        }
        return 0.0;
    }

    public static double powerOf2(int n) {
        if (n <= 1023 && n >= -1022) {
            return Double.longBitsToDouble((long)(n + 1023) << 52);
        }
        throw new IllegalArgumentException("Exponent out of bounds");
    }

    public static String toBinaryString(double d) {
        return new DoubleBits(d).toString();
    }

    public static double truncateToPowerOfTwo(double d) {
        DoubleBits doubleBits = new DoubleBits(d);
        doubleBits.zeroLowerBits(52);
        return doubleBits.getDouble();
    }

    public int biasedExponent() {
        return (int)(this.xBits >> 52) & 0x7FF;
    }

    public int getBit(int n) {
        n = (1L << n & this.xBits) != 0L ? 1 : 0;
        return n;
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.xBits);
    }

    public int getExponent() {
        return this.biasedExponent() - 1023;
    }

    public int numCommonMantissaBits(DoubleBits doubleBits) {
        int n = 0;
        while (n < 52) {
            if (this.getBit(n) != doubleBits.getBit(n)) {
                return n;
            }
            ++n;
        }
        return 52;
    }

    public String toString() {
        String string2 = Long.toBinaryString(this.xBits);
        CharSequence charSequence = new StringBuilder("0000000000000000000000000000000000000000000000000000000000000000");
        ((StringBuilder)charSequence).append(string2);
        charSequence = ((StringBuilder)charSequence).toString();
        string2 = ((String)charSequence).substring(((String)charSequence).length() - 64);
        charSequence = new StringBuilder(String.valueOf(string2.substring(0, 1)));
        ((StringBuilder)charSequence).append("  ");
        ((StringBuilder)charSequence).append(string2.substring(1, 12));
        ((StringBuilder)charSequence).append("(");
        ((StringBuilder)charSequence).append(this.getExponent());
        ((StringBuilder)charSequence).append(") ");
        ((StringBuilder)charSequence).append(string2.substring(12));
        ((StringBuilder)charSequence).append(" [ ");
        ((StringBuilder)charSequence).append(this.x);
        ((StringBuilder)charSequence).append(" ]");
        return ((StringBuilder)charSequence).toString();
    }

    public void zeroLowerBits(int n) {
        this.xBits = (1L << n) - 1L & this.xBits;
    }
}

