/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.quadtree.DoubleBits;

public class Key {
    private Envelope env = null;
    private int level = 0;
    private Coordinate pt = new Coordinate();

    public Key(Envelope envelope) {
        this.computeKey(envelope);
    }

    private void computeKey(int n, Envelope envelope) {
        double d = DoubleBits.powerOf2(n);
        this.pt.x = Math.floor(envelope.getMinX() / d) * d;
        this.pt.y = Math.floor(envelope.getMinY() / d) * d;
        this.env.init(this.pt.x, this.pt.x + d, this.pt.y, this.pt.y + d);
    }

    public static int computeQuadLevel(Envelope envelope) {
        double d;
        double d2 = envelope.getWidth();
        if (!(d2 > (d = envelope.getHeight()))) {
            d2 = d;
        }
        return DoubleBits.exponent(d2) + 1;
    }

    public void computeKey(Envelope envelope) {
        this.level = Key.computeQuadLevel(envelope);
        this.env = new Envelope();
        this.computeKey(this.level, envelope);
        while (!this.env.contains(envelope)) {
            int n;
            this.level = n = this.level + 1;
            this.computeKey(n, envelope);
        }
        return;
    }

    public Coordinate getCentre() {
        return new Coordinate((this.env.getMinX() + this.env.getMaxX()) / 2.0, (this.env.getMinY() + this.env.getMaxY()) / 2.0);
    }

    public Envelope getEnvelope() {
        return this.env;
    }

    public int getLevel() {
        return this.level;
    }

    public Coordinate getPoint() {
        return this.pt;
    }
}

