/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.quadtree.Key;
import com.vividsolutions.jts.index.quadtree.NodeBase;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;

public class Node
extends NodeBase {
    private double centrex;
    private double centrey;
    private Envelope env;
    private int level;

    public Node(Envelope envelope, int n) {
        this.env = envelope;
        this.level = n;
        this.centrex = (envelope.getMinX() + envelope.getMaxX()) / 2.0;
        this.centrey = (envelope.getMinY() + envelope.getMaxY()) / 2.0;
    }

    public static Node createExpanded(Node node, Envelope serializable) {
        serializable = new Envelope((Envelope)serializable);
        if (node != null) {
            ((Envelope)serializable).expandToInclude(node.env);
        }
        serializable = Node.createNode((Envelope)serializable);
        if (node != null) {
            ((Node)serializable).insertNode(node);
        }
        return serializable;
    }

    public static Node createNode(Envelope object) {
        object = new Key((Envelope)object);
        return new Node(((Key)object).getEnvelope(), ((Key)object).getLevel());
    }

    private Node createSubnode(int n) {
        double d;
        double d2;
        double d3;
        double d4;
        block4: {
            double d5;
            block5: {
                block0: {
                    block1: {
                        block2: {
                            block3: {
                                double d6;
                                if (n == 0) break block0;
                                if (n == 1) break block1;
                                if (n == 2) break block2;
                                if (n == 3) break block3;
                                d2 = d6 = (d4 = (d3 = 0.0));
                                d = d6;
                                break block4;
                            }
                            d5 = this.centrex;
                            d4 = this.env.getMaxX();
                            d = this.centrey;
                            d3 = this.env.getMaxY();
                            break block5;
                        }
                        d5 = this.env.getMinX();
                        d4 = this.centrex;
                        d = this.centrey;
                        d3 = this.env.getMaxY();
                        break block5;
                    }
                    d5 = this.centrex;
                    d4 = this.env.getMaxX();
                    d = this.env.getMinY();
                    d3 = this.centrey;
                    break block5;
                }
                d5 = this.env.getMinX();
                d4 = this.centrex;
                d = this.env.getMinY();
                d3 = this.centrey;
            }
            d2 = d3;
            d3 = d5;
        }
        return new Node(new Envelope(d3, d4, d, d2), this.level - 1);
    }

    private Node getSubnode(int n) {
        if (this.subnode[n] == null) {
            this.subnode[n] = this.createSubnode(n);
        }
        return this.subnode[n];
    }

    public NodeBase find(Envelope envelope) {
        int n = Node.getSubnodeIndex(envelope, this.centrex, this.centrey);
        if (n == -1) {
            return this;
        }
        if (this.subnode[n] != null) {
            return this.subnode[n].find(envelope);
        }
        return this;
    }

    public Envelope getEnvelope() {
        return this.env;
    }

    public Node getNode(Envelope envelope) {
        int n = Node.getSubnodeIndex(envelope, this.centrex, this.centrey);
        if (n != -1) {
            return this.getSubnode(n).getNode(envelope);
        }
        return this;
    }

    void insertNode(Node node) {
        Serializable serializable = this.env;
        boolean bl = serializable == null || ((Envelope)serializable).contains(node.env);
        Assert.isTrue(bl);
        int n = Node.getSubnodeIndex(node.env, this.centrex, this.centrey);
        if (node.level == this.level - 1) {
            this.subnode[n] = node;
        } else {
            serializable = this.createSubnode(n);
            ((Node)serializable).insertNode(node);
            this.subnode[n] = serializable;
        }
    }

    @Override
    protected boolean isSearchMatch(Envelope envelope) {
        return this.env.intersects(envelope);
    }
}

