/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.quadtree.Node;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class NodeBase
implements Serializable {
    protected List items = new ArrayList();
    protected Node[] subnode = new Node[4];

    public static int getSubnodeIndex(Envelope envelope, double d, double d2) {
        int n;
        double d3 = envelope.getMinX();
        int n2 = n = -1;
        if (d3 >= d) {
            n2 = n;
            if (envelope.getMinY() >= d2) {
                n2 = 3;
            }
            if (envelope.getMaxY() <= d2) {
                n2 = 1;
            }
        }
        n = n2;
        if (envelope.getMaxX() <= d) {
            if (envelope.getMinY() >= d2) {
                n2 = 2;
            }
            n = n2;
            if (envelope.getMaxY() <= d2) {
                n = 0;
            }
        }
        return n;
    }

    private void visitItems(Envelope object, ItemVisitor itemVisitor) {
        object = this.items.iterator();
        while (object.hasNext()) {
            itemVisitor.visitItem(object.next());
        }
        return;
    }

    public void add(Object object) {
        this.items.add(object);
    }

    public List addAllItems(List list) {
        list.addAll(this.items);
        int n = 0;
        while (n < 4) {
            Node[] nodeArray = this.subnode;
            if (nodeArray[n] != null) {
                nodeArray[n].addAllItems(list);
            }
            ++n;
        }
        return list;
    }

    public void addAllItemsFromOverlapping(Envelope envelope, List list) {
        if (!this.isSearchMatch(envelope)) {
            return;
        }
        list.addAll(this.items);
        int n = 0;
        while (n < 4) {
            Node[] nodeArray = this.subnode;
            if (nodeArray[n] != null) {
                nodeArray[n].addAllItemsFromOverlapping(envelope, list);
            }
            ++n;
        }
        return;
    }

    int depth() {
        int n = 0;
        int n2 = 0;
        while (n < 4) {
            Node[] nodeArray = this.subnode;
            int n3 = n2;
            if (nodeArray[n] != null) {
                int n4 = nodeArray[n].depth();
                n3 = n2;
                if (n4 > n2) {
                    n3 = n4;
                }
            }
            ++n;
            n2 = n3;
        }
        return n2 + 1;
    }

    public List getItems() {
        return this.items;
    }

    int getNodeCount() {
        int n = 0;
        int n2 = 0;
        while (n < 4) {
            Node[] nodeArray = this.subnode;
            int n3 = n2;
            if (nodeArray[n] != null) {
                n3 = n2 + nodeArray[n].size();
            }
            ++n;
            n2 = n3;
        }
        return n2 + 1;
    }

    public boolean hasChildren() {
        int n = 0;
        while (n < 4) {
            if (this.subnode[n] != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasItems() {
        return this.items.isEmpty() ^ true;
    }

    public boolean isEmpty() {
        boolean bl = this.items.isEmpty();
        int n = 0;
        while (n < 4) {
            Node[] nodeArray = this.subnode;
            boolean bl2 = bl;
            if (nodeArray[n] != null) {
                bl2 = bl;
                if (!nodeArray[n].isEmpty()) {
                    bl2 = false;
                }
            }
            ++n;
            bl = bl2;
        }
        return bl;
    }

    public boolean isPrunable() {
        boolean bl = !this.hasChildren() && !this.hasItems();
        return bl;
    }

    protected abstract boolean isSearchMatch(Envelope var1);

    public boolean remove(Envelope envelope, Object object) {
        boolean bl = this.isSearchMatch(envelope);
        int n = 0;
        if (!bl) {
            return false;
        }
        bl = false;
        while (true) {
            boolean bl2;
            block9: {
                block8: {
                    block7: {
                        if (n < 4) break block7;
                        bl2 = bl;
                        break block8;
                    }
                    Node[] nodeArray = this.subnode;
                    bl2 = bl;
                    if (nodeArray[n] == null) break block9;
                    bl2 = bl = nodeArray[n].remove(envelope, object);
                    if (!bl) break block9;
                    bl2 = bl;
                    if (this.subnode[n].isPrunable()) {
                        this.subnode[n] = null;
                        bl2 = bl;
                    }
                }
                if (bl2) {
                    return bl2;
                }
                return this.items.remove(object);
            }
            ++n;
            bl = bl2;
        }
    }

    int size() {
        int n = 0;
        int n2 = 0;
        while (n < 4) {
            Node[] nodeArray = this.subnode;
            int n3 = n2;
            if (nodeArray[n] != null) {
                n3 = n2 + nodeArray[n].size();
            }
            ++n;
            n2 = n3;
        }
        return n2 + this.items.size();
    }

    public void visit(Envelope envelope, ItemVisitor itemVisitor) {
        if (!this.isSearchMatch(envelope)) {
            return;
        }
        this.visitItems(envelope, itemVisitor);
        int n = 0;
        while (n < 4) {
            Node[] nodeArray = this.subnode;
            if (nodeArray[n] != null) {
                nodeArray[n].visit(envelope, itemVisitor);
            }
            ++n;
        }
        return;
    }
}

