/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.quadtree.IntervalSize;
import com.vividsolutions.jts.index.quadtree.Node;
import com.vividsolutions.jts.index.quadtree.NodeBase;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;

public class Root
extends NodeBase {
    private static final Coordinate origin = new Coordinate(0.0, 0.0);

    private void insertContained(Node nodeBase, Envelope envelope, Object object) {
        Assert.isTrue(((Node)nodeBase).getEnvelope().contains(envelope));
        boolean bl = IntervalSize.isZeroWidth(envelope.getMinX(), envelope.getMaxX());
        boolean bl2 = IntervalSize.isZeroWidth(envelope.getMinY(), envelope.getMaxY());
        nodeBase = !bl && !bl2 ? ((Node)nodeBase).getNode(envelope) : ((Node)nodeBase).find(envelope);
        nodeBase.add(object);
    }

    public void insert(Envelope envelope, Object object) {
        Serializable serializable = origin;
        int n = Root.getSubnodeIndex(envelope, ((Coordinate)serializable).x, ((Coordinate)serializable).y);
        if (n == -1) {
            this.add(object);
            return;
        }
        serializable = this.subnode[n];
        if (serializable == null || !((Node)serializable).getEnvelope().contains(envelope)) {
            serializable = Node.createExpanded((Node)serializable, envelope);
            this.subnode[n] = serializable;
        }
        this.insertContained(this.subnode[n], envelope, object);
    }

    @Override
    protected boolean isSearchMatch(Envelope envelope) {
        return true;
    }
}

