/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSTRtree
implements Serializable {
    private static final int DEFAULT_NODE_CAPACITY = 10;
    private static final long serialVersionUID = -3886435814360241337L;
    private boolean built;
    private ArrayList itemBoundables;
    private int nodeCapacity;
    protected AbstractNode root;

    public AbstractSTRtree() {
        this(10);
    }

    public AbstractSTRtree(int n) {
        boolean bl = false;
        this.built = false;
        this.itemBoundables = new ArrayList();
        if (n > 1) {
            bl = true;
        }
        Assert.isTrue(bl, "Node capacity must be greater than 1");
        this.nodeCapacity = n;
    }

    private void boundablesAtLevel(int n, AbstractNode boundable, Collection collection) {
        boolean bl = n > -2;
        Assert.isTrue(bl);
        if (boundable.getLevel() == n) {
            collection.add(boundable);
            return;
        }
        Iterator iterator2 = boundable.getChildBoundables().iterator();
        while (iterator2.hasNext()) {
            boundable = (Boundable)iterator2.next();
            if (boundable instanceof AbstractNode) {
                this.boundablesAtLevel(n, (AbstractNode)boundable, collection);
                continue;
            }
            Assert.isTrue(boundable instanceof ItemBoundable);
            if (n != -1) continue;
            collection.add(boundable);
        }
        return;
    }

    protected static int compareDoubles(double d, double d2) {
        int n = d > d2 ? 1 : (d < d2 ? -1 : 0);
        return n;
    }

    private AbstractNode createHigherLevels(List list, int n) {
        Assert.isTrue(list.isEmpty() ^ true);
        list = this.createParentBoundables(list, ++n);
        if (list.size() == 1) {
            return (AbstractNode)list.get(0);
        }
        return this.createHigherLevels(list, n);
    }

    private List itemsTree(AbstractNode object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = ((AbstractNode)object).getChildBoundables().iterator();
        while (true) {
            if (!object.hasNext()) {
                if (arrayList.size() <= 0) {
                    return null;
                }
                return arrayList;
            }
            Object object2 = (Boundable)object.next();
            if (object2 instanceof AbstractNode) {
                if ((object2 = this.itemsTree((AbstractNode)object2)) == null) continue;
                arrayList.add(object2);
                continue;
            }
            if (object2 instanceof ItemBoundable) {
                arrayList.add(((ItemBoundable)object2).getItem());
                continue;
            }
            Assert.shouldNeverReachHere();
        }
    }

    private void query(Object object, AbstractNode object2, ItemVisitor itemVisitor) {
        object2 = ((AbstractNode)object2).getChildBoundables();
        int n = 0;
        while (n < object2.size()) {
            Boundable boundable = (Boundable)object2.get(n);
            if (this.getIntersectsOp().intersects(boundable.getBounds(), object)) {
                if (boundable instanceof AbstractNode) {
                    this.query(object, (AbstractNode)boundable, itemVisitor);
                } else if (boundable instanceof ItemBoundable) {
                    itemVisitor.visitItem(((ItemBoundable)boundable).getItem());
                } else {
                    Assert.shouldNeverReachHere();
                }
            }
            ++n;
        }
        return;
    }

    private void query(Object object, AbstractNode object2, List list) {
        object2 = ((AbstractNode)object2).getChildBoundables();
        int n = 0;
        while (n < object2.size()) {
            Boundable boundable = (Boundable)object2.get(n);
            if (this.getIntersectsOp().intersects(boundable.getBounds(), object)) {
                if (boundable instanceof AbstractNode) {
                    this.query(object, (AbstractNode)boundable, list);
                } else if (boundable instanceof ItemBoundable) {
                    list.add(((ItemBoundable)boundable).getItem());
                } else {
                    Assert.shouldNeverReachHere();
                }
            }
            ++n;
        }
        return;
    }

    private boolean remove(Object object, AbstractNode abstractNode, Object object2) {
        boolean bl;
        block4: {
            boolean bl2;
            Boundable boundable;
            bl = this.removeItem(abstractNode, object2);
            if (bl) {
                return true;
            }
            Object var5_5 = null;
            Iterator iterator2 = abstractNode.getChildBoundables().iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    object = var5_5;
                    break block4;
                }
                boundable = (Boundable)iterator2.next();
                if (!this.getIntersectsOp().intersects(boundable.getBounds(), object) || !(boundable instanceof AbstractNode)) continue;
                boundable = (AbstractNode)boundable;
                bl = bl2 = this.remove(object, (AbstractNode)boundable, object2);
                if (bl2) break;
            }
            object = boundable;
            bl = bl2;
        }
        if (object != null && ((AbstractNode)object).getChildBoundables().isEmpty()) {
            abstractNode.getChildBoundables().remove(object);
        }
        return bl;
    }

    private boolean removeItem(AbstractNode abstractNode, Object object) {
        Iterator iterator2 = abstractNode.getChildBoundables().iterator();
        Boundable boundable = null;
        while (true) {
            if (!iterator2.hasNext()) {
                if (boundable != null) {
                    abstractNode.getChildBoundables().remove(boundable);
                    return true;
                }
                return false;
            }
            Boundable boundable2 = (Boundable)iterator2.next();
            if (!(boundable2 instanceof ItemBoundable) || ((ItemBoundable)boundable2).getItem() != object) continue;
            boundable = boundable2;
        }
    }

    protected List boundablesAtLevel(int n) {
        ArrayList arrayList = new ArrayList();
        this.boundablesAtLevel(n, this.root, arrayList);
        return arrayList;
    }

    public void build() {
        synchronized (this) {
            block4: {
                boolean bl = this.built;
                if (!bl) break block4;
                return;
            }
            AbstractNode abstractNode = this.itemBoundables.isEmpty() ? this.createNode(0) : this.createHigherLevels(this.itemBoundables, -1);
            this.root = abstractNode;
            this.itemBoundables = null;
            this.built = true;
            return;
        }
    }

    protected abstract AbstractNode createNode(int var1);

    protected List createParentBoundables(List object, int n) {
        Assert.isTrue(object.isEmpty() ^ true);
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        arrayList.add(this.createNode(n));
        object = new ArrayList(object);
        Collections.sort(object, this.getComparator());
        Iterator iterator2 = ((ArrayList)object).iterator();
        while (iterator2.hasNext()) {
            object = (Boundable)iterator2.next();
            if (this.lastNode(arrayList).getChildBoundables().size() == this.getNodeCapacity()) {
                arrayList.add(this.createNode(n));
            }
            this.lastNode(arrayList).addChildBoundable((Boundable)object);
        }
        return arrayList;
    }

    protected int depth() {
        if (this.isEmpty()) {
            return 0;
        }
        this.build();
        return this.depth(this.root);
    }

    protected int depth(AbstractNode boundable) {
        Iterator iterator2 = boundable.getChildBoundables().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int n2;
            boundable = (Boundable)iterator2.next();
            if (!(boundable instanceof AbstractNode) || (n2 = this.depth((AbstractNode)boundable)) <= n) continue;
            n = n2;
        }
        return n + 1;
    }

    protected abstract Comparator getComparator();

    protected abstract IntersectsOp getIntersectsOp();

    public int getNodeCapacity() {
        return this.nodeCapacity;
    }

    public AbstractNode getRoot() {
        this.build();
        return this.root;
    }

    protected void insert(Object object, Object object2) {
        Assert.isTrue(this.built ^ true, "Cannot insert items into an STR packed R-tree after it has been built.");
        this.itemBoundables.add(new ItemBoundable(object, object2));
    }

    public boolean isEmpty() {
        if (!this.built) {
            return this.itemBoundables.isEmpty();
        }
        return this.root.isEmpty();
    }

    public List itemsTree() {
        ArrayList arrayList;
        this.build();
        ArrayList arrayList2 = arrayList = this.itemsTree(this.root);
        if (arrayList == null) {
            arrayList2 = new ArrayList();
        }
        return arrayList2;
    }

    protected AbstractNode lastNode(List list) {
        return (AbstractNode)list.get(list.size() - 1);
    }

    protected List query(Object object) {
        this.build();
        ArrayList arrayList = new ArrayList();
        if (this.isEmpty()) {
            return arrayList;
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), object)) {
            this.query(object, this.root, arrayList);
        }
        return arrayList;
    }

    protected void query(Object object, ItemVisitor itemVisitor) {
        this.build();
        if (this.isEmpty()) {
            return;
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), object)) {
            this.query(object, this.root, itemVisitor);
        }
    }

    protected boolean remove(Object object, Object object2) {
        this.build();
        if (this.getIntersectsOp().intersects(this.root.getBounds(), object)) {
            return this.remove(object, this.root, object2);
        }
        return false;
    }

    protected int size() {
        if (this.isEmpty()) {
            return 0;
        }
        this.build();
        return this.size(this.root);
    }

    protected int size(AbstractNode boundable) {
        Iterator iterator2 = boundable.getChildBoundables().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            boundable = (Boundable)iterator2.next();
            if (boundable instanceof AbstractNode) {
                n += this.size((AbstractNode)boundable);
                continue;
            }
            if (!(boundable instanceof ItemBoundable)) continue;
            ++n;
        }
        return n;
    }

    protected static interface IntersectsOp {
        public boolean intersects(Object var1, Object var2);
    }
}

