/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.util.Assert;

public class Interval {
    private double max;
    private double min;

    public Interval(double d, double d2) {
        boolean bl = d <= d2;
        Assert.isTrue(bl);
        this.min = d;
        this.max = d2;
    }

    public Interval(Interval interval) {
        this(interval.min, interval.max);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Interval)) {
            return false;
        }
        object = (Interval)object;
        return this.min == ((Interval)object).min && this.max == ((Interval)object).max;
    }

    public Interval expandToInclude(Interval interval) {
        this.max = Math.max(this.max, interval.max);
        this.min = Math.min(this.min, interval.min);
        return this;
    }

    public double getCentre() {
        return (this.min + this.max) / 2.0;
    }

    public boolean intersects(Interval interval) {
        boolean bl = !(interval.min > this.max) && !(interval.max < this.min);
        return bl;
    }
}

