/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.AbstractSTRtree;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.index.strtree.BoundablePair;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.index.strtree.ItemDistance;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jts.util.PriorityQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class STRtree
extends AbstractSTRtree
implements SpatialIndex,
Serializable {
    private static final int DEFAULT_NODE_CAPACITY = 10;
    private static AbstractSTRtree.IntersectsOp intersectsOp;
    private static final long serialVersionUID = 259274702368956900L;
    private static Comparator xComparator;
    private static Comparator yComparator;

    static {
        xComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return STRtree.compareDoubles(STRtree.centreX((Envelope)((Boundable)object).getBounds()), STRtree.centreX((Envelope)((Boundable)object2).getBounds()));
            }
        };
        yComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return STRtree.compareDoubles(STRtree.centreY((Envelope)((Boundable)object).getBounds()), STRtree.centreY((Envelope)((Boundable)object2).getBounds()));
            }
        };
        intersectsOp = new AbstractSTRtree.IntersectsOp(){

            @Override
            public boolean intersects(Object object, Object object2) {
                return ((Envelope)object).intersects((Envelope)object2);
            }
        };
    }

    public STRtree() {
        this(10);
    }

    public STRtree(int n) {
        super(n);
    }

    private static double avg(double d, double d2) {
        return (d + d2) / 2.0;
    }

    private static double centreX(Envelope envelope) {
        return STRtree.avg(envelope.getMinX(), envelope.getMaxX());
    }

    private static double centreY(Envelope envelope) {
        return STRtree.avg(envelope.getMinY(), envelope.getMaxY());
    }

    private List createParentBoundablesFromVerticalSlices(List[] listArray, int n) {
        int n2 = listArray.length;
        int n3 = 0;
        boolean bl = n2 > 0;
        Assert.isTrue(bl);
        ArrayList arrayList = new ArrayList();
        while (n3 < listArray.length) {
            arrayList.addAll(this.createParentBoundablesFromVerticalSlice(listArray[n3], n));
            ++n3;
        }
        return arrayList;
    }

    private Object[] nearestNeighbour(BoundablePair boundablePair) {
        return this.nearestNeighbour(boundablePair, Double.POSITIVE_INFINITY);
    }

    private Object[] nearestNeighbour(BoundablePair boundablePair, double d) {
        BoundablePair boundablePair2;
        double d2;
        PriorityQueue priorityQueue = new PriorityQueue();
        priorityQueue.add(boundablePair);
        boundablePair = null;
        while (!priorityQueue.isEmpty() && d > 0.0 && !((d2 = (boundablePair2 = (BoundablePair)priorityQueue.poll()).getDistance()) >= d)) {
            if (boundablePair2.isLeaves()) {
                boundablePair = boundablePair2;
                d = d2;
                continue;
            }
            boundablePair2.expandToQueue(priorityQueue, d);
        }
        return new Object[]{((ItemBoundable)boundablePair.getBoundable(0)).getItem(), ((ItemBoundable)boundablePair.getBoundable(1)).getItem()};
    }

    @Override
    protected AbstractNode createNode(int n) {
        return new STRtreeNode(n);
    }

    @Override
    protected List createParentBoundables(List arrayList, int n) {
        Assert.isTrue(arrayList.isEmpty() ^ true);
        int n2 = (int)Math.ceil((double)arrayList.size() / (double)this.getNodeCapacity());
        arrayList = new ArrayList(arrayList);
        Collections.sort(arrayList, xComparator);
        return this.createParentBoundablesFromVerticalSlices(this.verticalSlices(arrayList, (int)Math.ceil(Math.sqrt(n2))), n);
    }

    protected List createParentBoundablesFromVerticalSlice(List list, int n) {
        return super.createParentBoundables(list, n);
    }

    @Override
    public int depth() {
        return super.depth();
    }

    @Override
    protected Comparator getComparator() {
        return yComparator;
    }

    @Override
    protected AbstractSTRtree.IntersectsOp getIntersectsOp() {
        return intersectsOp;
    }

    @Override
    public void insert(Envelope envelope, Object object) {
        if (envelope.isNull()) {
            return;
        }
        super.insert(envelope, object);
    }

    public Object nearestNeighbour(Envelope serializable, Object object, ItemDistance itemDistance) {
        serializable = new ItemBoundable(serializable, object);
        return this.nearestNeighbour(new BoundablePair(this.getRoot(), (Boundable)((Object)serializable), itemDistance))[0];
    }

    public Object[] nearestNeighbour(ItemDistance itemDistance) {
        return this.nearestNeighbour(new BoundablePair(this.getRoot(), this.getRoot(), itemDistance));
    }

    public Object[] nearestNeighbour(STRtree sTRtree, ItemDistance itemDistance) {
        return this.nearestNeighbour(new BoundablePair(this.getRoot(), sTRtree.getRoot(), itemDistance));
    }

    @Override
    public List query(Envelope envelope) {
        return super.query(envelope);
    }

    @Override
    public void query(Envelope envelope, ItemVisitor itemVisitor) {
        super.query(envelope, itemVisitor);
    }

    @Override
    public boolean remove(Envelope envelope, Object object) {
        return super.remove(envelope, object);
    }

    @Override
    public int size() {
        return super.size();
    }

    protected List[] verticalSlices(List object, int n) {
        int n2 = (int)Math.ceil((double)object.size() / (double)n);
        List[] listArray = new List[n];
        object = object.iterator();
        int n3 = 0;
        while (n3 < n) {
            listArray[n3] = new ArrayList();
            for (int i = 0; object.hasNext() && i < n2; ++i) {
                Boundable boundable = (Boundable)object.next();
                listArray[n3].add(boundable);
            }
            ++n3;
        }
        return listArray;
    }

    private static final class STRtreeNode
    extends AbstractNode {
        private STRtreeNode(int n) {
            super(n);
        }

        @Override
        protected Object computeBounds() {
            Iterator iterator2 = this.getChildBoundables().iterator();
            Envelope envelope = null;
            while (iterator2.hasNext()) {
                Boundable boundable = (Boundable)iterator2.next();
                if (envelope == null) {
                    envelope = new Envelope((Envelope)boundable.getBounds());
                    continue;
                }
                envelope.expandToInclude((Envelope)boundable.getBounds());
            }
            return envelope;
        }
    }
}

