/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.sweepline;

import com.vividsolutions.jts.index.sweepline.SweepLineEvent;
import com.vividsolutions.jts.index.sweepline.SweepLineInterval;
import com.vividsolutions.jts.index.sweepline.SweepLineOverlapAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SweepLineIndex {
    List events = new ArrayList();
    private boolean indexBuilt;
    private int nOverlaps;

    private void buildIndex() {
        if (this.indexBuilt) {
            return;
        }
        Collections.sort(this.events);
        int n = 0;
        while (true) {
            if (n >= this.events.size()) {
                this.indexBuilt = true;
                return;
            }
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(n);
            if (sweepLineEvent.isDelete()) {
                sweepLineEvent.getInsertEvent().setDeleteEventIndex(n);
            }
            ++n;
        }
    }

    private void processOverlaps(int n, int n2, SweepLineInterval sweepLineInterval, SweepLineOverlapAction sweepLineOverlapAction) {
        while (n < n2) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(n);
            if (sweepLineEvent.isInsert()) {
                sweepLineOverlapAction.overlap(sweepLineInterval, sweepLineEvent.getInterval());
                ++this.nOverlaps;
            }
            ++n;
        }
        return;
    }

    public void add(SweepLineInterval sweepLineInterval) {
        SweepLineEvent sweepLineEvent = new SweepLineEvent(sweepLineInterval.getMin(), null, sweepLineInterval);
        this.events.add(sweepLineEvent);
        this.events.add(new SweepLineEvent(sweepLineInterval.getMax(), sweepLineEvent, sweepLineInterval));
    }

    public void computeOverlaps(SweepLineOverlapAction sweepLineOverlapAction) {
        int n = 0;
        this.nOverlaps = 0;
        this.buildIndex();
        while (n < this.events.size()) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(n);
            if (sweepLineEvent.isInsert()) {
                this.processOverlaps(n, sweepLineEvent.getDeleteEventIndex(), sweepLineEvent.getInterval(), sweepLineOverlapAction);
            }
            ++n;
        }
        return;
    }
}

