/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

public class ByteOrderValues {
    public static final int BIG_ENDIAN = 1;
    public static final int LITTLE_ENDIAN = 2;

    public static double getDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(ByteOrderValues.getLong(byArray, n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getInt(byte[] byArray, int n) {
        byte by;
        if (n == 1) {
            n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8;
            by = byArray[3];
            return by & 0xFF | n;
        }
        n = (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8;
        by = byArray[0];
        return by & 0xFF | n;
    }

    public static long getLong(byte[] byArray, int n) {
        if (n == 1) {
            return (long)(byArray[0] & 0xFF) << 56 | (long)(byArray[1] & 0xFF) << 48 | (long)(byArray[2] & 0xFF) << 40 | (long)(byArray[3] & 0xFF) << 32 | (long)(byArray[4] & 0xFF) << 24 | (long)(byArray[5] & 0xFF) << 16 | (long)(byArray[6] & 0xFF) << 8 | (long)(byArray[7] & 0xFF);
        }
        return (long)(byArray[7] & 0xFF) << 56 | (long)(byArray[6] & 0xFF) << 48 | (long)(byArray[5] & 0xFF) << 40 | (long)(byArray[4] & 0xFF) << 32 | (long)(byArray[3] & 0xFF) << 24 | (long)(byArray[2] & 0xFF) << 16 | (long)(byArray[1] & 0xFF) << 8 | (long)(byArray[0] & 0xFF);
    }

    public static void putDouble(double d, byte[] byArray, int n) {
        ByteOrderValues.putLong(Double.doubleToLongBits(d), byArray, n);
    }

    public static void putInt(int n, byte[] byArray, int n2) {
        if (n2 == 1) {
            byArray[0] = (byte)(n >> 24);
            byArray[1] = (byte)(n >> 16);
            byArray[2] = (byte)(n >> 8);
            byArray[3] = (byte)n;
        } else {
            byArray[0] = (byte)n;
            byArray[1] = (byte)(n >> 8);
            byArray[2] = (byte)(n >> 16);
            byArray[3] = (byte)(n >> 24);
        }
    }

    public static void putLong(long l, byte[] byArray, int n) {
        if (n == 1) {
            byArray[0] = (byte)(l >> 56);
            byArray[1] = (byte)(l >> 48);
            byArray[2] = (byte)(l >> 40);
            byArray[3] = (byte)(l >> 32);
            byArray[4] = (byte)(l >> 24);
            byArray[5] = (byte)(l >> 16);
            byArray[6] = (byte)(l >> 8);
            byArray[7] = (byte)l;
        } else {
            byArray[0] = (byte)l;
            byArray[1] = (byte)(l >> 8);
            byArray[2] = (byte)(l >> 16);
            byArray[3] = (byte)(l >> 24);
            byArray[4] = (byte)(l >> 32);
            byArray[5] = (byte)(l >> 40);
            byArray[6] = (byte)(l >> 48);
            byArray[7] = (byte)(l >> 56);
        }
    }
}

