/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;

public class WKTReader {
    private static final boolean ALLOW_OLD_JTS_MULTIPOINT_SYNTAX = true;
    private static final String COMMA = ",";
    private static final String EMPTY = "EMPTY";
    private static final String L_PAREN = "(";
    private static final String NAN_SYMBOL = "NaN";
    private static final String R_PAREN = ")";
    private GeometryFactory geometryFactory;
    private PrecisionModel precisionModel;
    private StreamTokenizer tokenizer;

    public WKTReader() {
        this(new GeometryFactory());
    }

    public WKTReader(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.precisionModel = geometryFactory.getPrecisionModel();
    }

    private Coordinate[] getCoordinates() throws IOException, ParseException {
        if (this.getNextEmptyOrOpener().equals(EMPTY)) {
            return new Coordinate[0];
        }
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        arrayList.add(this.getPreciseCoordinate());
        String string2 = this.getNextCloserOrComma();
        while (string2.equals(COMMA)) {
            arrayList.add(this.getPreciseCoordinate());
            string2 = this.getNextCloserOrComma();
        }
        return arrayList.toArray(new Coordinate[arrayList.size()]);
    }

    private Coordinate[] getCoordinatesNoLeftParen() throws IOException, ParseException {
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        arrayList.add(this.getPreciseCoordinate());
        String string2 = this.getNextCloserOrComma();
        while (string2.equals(COMMA)) {
            arrayList.add(this.getPreciseCoordinate());
            string2 = this.getNextCloserOrComma();
        }
        return arrayList.toArray(new Coordinate[arrayList.size()]);
    }

    private String getNextCloser() throws IOException, ParseException {
        String string2 = this.getNextWord();
        if (string2.equals(R_PAREN)) {
            return string2;
        }
        this.parseErrorExpected(R_PAREN);
        return null;
    }

    private String getNextCloserOrComma() throws IOException, ParseException {
        String string2;
        String string3 = string2 = this.getNextWord();
        if (!string2.equals(COMMA)) {
            if (string2.equals(R_PAREN)) {
                string3 = string2;
            } else {
                this.parseErrorExpected(", or )");
                string3 = null;
            }
        }
        return string3;
    }

    private String getNextEmptyOrOpener() throws IOException, ParseException {
        String string2;
        String string3 = string2 = this.getNextWord();
        if (!string2.equals(EMPTY)) {
            if (string2.equals(L_PAREN)) {
                string3 = string2;
            } else {
                this.parseErrorExpected("EMPTY or (");
                string3 = null;
            }
        }
        return string3;
    }

    private double getNextNumber() throws IOException, ParseException {
        if (this.tokenizer.nextToken() == -3) {
            if (this.tokenizer.sval.equalsIgnoreCase(NAN_SYMBOL)) {
                return Double.NaN;
            }
            try {
                double d = Double.parseDouble(this.tokenizer.sval);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                StringBuilder stringBuilder = new StringBuilder("Invalid number: ");
                stringBuilder.append(this.tokenizer.sval);
                this.parseErrorWithLine(stringBuilder.toString());
            }
        }
        this.parseErrorExpected("number");
        return 0.0;
    }

    private String getNextWord() throws IOException, ParseException {
        int n = this.tokenizer.nextToken();
        if (n != -3) {
            if (n != 44) {
                if (n != 40) {
                    if (n != 41) {
                        this.parseErrorExpected("word");
                        return null;
                    }
                    return R_PAREN;
                }
                return L_PAREN;
            }
            return COMMA;
        }
        String string2 = this.tokenizer.sval;
        if (string2.equalsIgnoreCase(EMPTY)) {
            return EMPTY;
        }
        return string2;
    }

    private Coordinate getPreciseCoordinate() throws IOException, ParseException {
        Coordinate coordinate = new Coordinate();
        coordinate.x = this.getNextNumber();
        coordinate.y = this.getNextNumber();
        if (this.isNumberNext()) {
            coordinate.z = this.getNextNumber();
        }
        this.precisionModel.makePrecise(coordinate);
        return coordinate;
    }

    private boolean isNumberNext() throws IOException {
        int n = this.tokenizer.nextToken();
        this.tokenizer.pushBack();
        return n == -3;
    }

    private String lookaheadWord() throws IOException, ParseException {
        String string2 = this.getNextWord();
        this.tokenizer.pushBack();
        return string2;
    }

    private void parseErrorExpected(String string2) throws ParseException {
        if (this.tokenizer.ttype == -2) {
            Assert.shouldNeverReachHere("Unexpected NUMBER token");
        }
        if (this.tokenizer.ttype == 10) {
            Assert.shouldNeverReachHere("Unexpected EOL token");
        }
        String string3 = this.tokenString();
        StringBuilder stringBuilder = new StringBuilder("Expected ");
        stringBuilder.append(string2);
        stringBuilder.append(" but found ");
        stringBuilder.append(string3);
        this.parseErrorWithLine(stringBuilder.toString());
    }

    private void parseErrorWithLine(String charSequence) throws ParseException {
        charSequence = new StringBuilder(String.valueOf(charSequence));
        ((StringBuilder)charSequence).append(" (line ");
        ((StringBuilder)charSequence).append(this.tokenizer.lineno());
        ((StringBuilder)charSequence).append(R_PAREN);
        throw new ParseException(((StringBuilder)charSequence).toString());
    }

    private GeometryCollection readGeometryCollectionText() throws IOException, ParseException {
        if (this.getNextEmptyOrOpener().equals(EMPTY)) {
            return this.geometryFactory.createGeometryCollection(new Geometry[0]);
        }
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        arrayList.add(this.readGeometryTaggedText());
        Object object = this.getNextCloserOrComma();
        while (true) {
            if (!object.equals(COMMA)) {
                object = new Geometry[arrayList.size()];
                return this.geometryFactory.createGeometryCollection(arrayList.toArray((T[])object));
            }
            arrayList.add(this.readGeometryTaggedText());
            object = this.getNextCloserOrComma();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Geometry readGeometryTaggedText() throws IOException, ParseException {
        String string2;
        block10: {
            try {
                string2 = this.getNextWord();
                if (!string2.equalsIgnoreCase("POINT")) break block10;
            }
            catch (ParseException | IOException exception) {
                return null;
            }
            return this.readPointText();
        }
        if (string2.equalsIgnoreCase("LINESTRING")) {
            return this.readLineStringText();
        }
        if (string2.equalsIgnoreCase("LINEARRING")) {
            return this.readLinearRingText();
        }
        if (string2.equalsIgnoreCase("POLYGON")) {
            return this.readPolygonText();
        }
        if (string2.equalsIgnoreCase("MULTIPOINT")) {
            return this.readMultiPointText();
        }
        if (string2.equalsIgnoreCase("MULTILINESTRING")) {
            return this.readMultiLineStringText();
        }
        if (string2.equalsIgnoreCase("MULTIPOLYGON")) {
            return this.readMultiPolygonText();
        }
        if (string2.equalsIgnoreCase("GEOMETRYCOLLECTION")) {
            return this.readGeometryCollectionText();
        }
        StringBuilder stringBuilder = new StringBuilder("Unknown geometry type: ");
        stringBuilder.append(string2);
        this.parseErrorWithLine(stringBuilder.toString());
        return null;
    }

    private LineString readLineStringText() throws IOException, ParseException {
        return this.geometryFactory.createLineString(this.getCoordinates());
    }

    private LinearRing readLinearRingText() throws IOException, ParseException {
        return this.geometryFactory.createLinearRing(this.getCoordinates());
    }

    private MultiLineString readMultiLineStringText() throws IOException, ParseException {
        if (this.getNextEmptyOrOpener().equals(EMPTY)) {
            return this.geometryFactory.createMultiLineString(new LineString[0]);
        }
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        arrayList.add(this.readLineStringText());
        Object object = this.getNextCloserOrComma();
        while (true) {
            if (!object.equals(COMMA)) {
                object = new LineString[arrayList.size()];
                return this.geometryFactory.createMultiLineString(arrayList.toArray((T[])object));
            }
            arrayList.add(this.readLineStringText());
            object = this.getNextCloserOrComma();
        }
    }

    private MultiPoint readMultiPointText() throws IOException, ParseException {
        if (this.getNextEmptyOrOpener().equals(EMPTY)) {
            return this.geometryFactory.createMultiPoint(new Point[0]);
        }
        if (this.lookaheadWord() != L_PAREN) {
            return this.geometryFactory.createMultiPoint(this.toPoints(this.getCoordinatesNoLeftParen()));
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(this.readPointText());
        Object object = this.getNextCloserOrComma();
        while (true) {
            if (!object.equals(COMMA)) {
                object = new Point[arrayList.size()];
                return this.geometryFactory.createMultiPoint(arrayList.toArray((T[])object));
            }
            arrayList.add(this.readPointText());
            object = this.getNextCloserOrComma();
        }
    }

    private MultiPolygon readMultiPolygonText() throws IOException, ParseException {
        if (this.getNextEmptyOrOpener().equals(EMPTY)) {
            return this.geometryFactory.createMultiPolygon(new Polygon[0]);
        }
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        arrayList.add(this.readPolygonText());
        Object object = this.getNextCloserOrComma();
        while (true) {
            if (!object.equals(COMMA)) {
                object = new Polygon[arrayList.size()];
                return this.geometryFactory.createMultiPolygon(arrayList.toArray((T[])object));
            }
            arrayList.add(this.readPolygonText());
            object = this.getNextCloserOrComma();
        }
    }

    private Point readPointText() throws IOException, ParseException {
        if (this.getNextEmptyOrOpener().equals(EMPTY)) {
            return this.geometryFactory.createPoint((Coordinate)null);
        }
        Point point = this.geometryFactory.createPoint(this.getPreciseCoordinate());
        this.getNextCloser();
        return point;
    }

    private Polygon readPolygonText() throws IOException, ParseException {
        if (this.getNextEmptyOrOpener().equals(EMPTY)) {
            GeometryFactory geometryFactory = this.geometryFactory;
            return geometryFactory.createPolygon(geometryFactory.createLinearRing(new Coordinate[0]), new LinearRing[0]);
        }
        ArrayList<LinearRing> arrayList = new ArrayList<LinearRing>();
        LinearRing linearRing = this.readLinearRingText();
        Object object = this.getNextCloserOrComma();
        while (true) {
            if (!object.equals(COMMA)) {
                object = new LinearRing[arrayList.size()];
                return this.geometryFactory.createPolygon(linearRing, arrayList.toArray((T[])object));
            }
            arrayList.add(this.readLinearRingText());
            object = this.getNextCloserOrComma();
        }
    }

    private Point[] toPoints(Coordinate[] coordinateArray) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n = 0;
        while (n < coordinateArray.length) {
            arrayList.add(this.geometryFactory.createPoint(coordinateArray[n]));
            ++n;
        }
        return arrayList.toArray(new Point[0]);
    }

    private String tokenString() {
        int n = this.tokenizer.ttype;
        if (n != -3) {
            if (n != -2) {
                if (n != -1) {
                    if (n != 10) {
                        StringBuilder stringBuilder = new StringBuilder("'");
                        stringBuilder.append((char)this.tokenizer.ttype);
                        stringBuilder.append("'");
                        return stringBuilder.toString();
                    }
                    return "End-of-Line";
                }
                return "End-of-Stream";
            }
            return "<NUMBER>";
        }
        StringBuilder stringBuilder = new StringBuilder("'");
        stringBuilder.append(this.tokenizer.sval);
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    public Geometry read(Reader object) throws ParseException {
        this.tokenizer = object = new StreamTokenizer((Reader)object);
        ((StreamTokenizer)object).resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(160, 255);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(45, 45);
        this.tokenizer.wordChars(43, 43);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        try {
            object = this.readGeometryTaggedText();
            return object;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    public Geometry read(String object) throws ParseException {
        object = new StringReader((String)object);
        try {
            Geometry geometry = this.read((Reader)object);
            return geometry;
        }
        finally {
            ((StringReader)object).close();
        }
    }
}

