/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class WKTWriter {
    private static final int INDENT = 2;
    private int coordsPerLine = -1;
    private DecimalFormat formatter;
    private String indentTabStr = "  ";
    private boolean isFormatted = false;
    private int level = 0;
    private int outputDimension = 2;
    private boolean useFormatting = false;

    public WKTWriter() {
    }

    public WKTWriter(int n) {
        this.outputDimension = n;
        if (n >= 2 && n <= 3) {
            return;
        }
        throw new IllegalArgumentException("Invalid output dimension (must be 2 or 3)");
    }

    private void appendCoordinate(Coordinate coordinate, Writer writer) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.writeNumber(coordinate.x)));
        stringBuilder.append(" ");
        stringBuilder.append(this.writeNumber(coordinate.y));
        writer.write(stringBuilder.toString());
        if (this.outputDimension >= 3 && !Double.isNaN(coordinate.z)) {
            writer.write(" ");
            writer.write(this.writeNumber(coordinate.z));
        }
    }

    private void appendCoordinate(CoordinateSequence coordinateSequence, int n, Writer writer) throws IOException {
        double d;
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.writeNumber(coordinateSequence.getX(n))));
        stringBuilder.append(" ");
        stringBuilder.append(this.writeNumber(coordinateSequence.getY(n)));
        writer.write(stringBuilder.toString());
        if (this.outputDimension >= 3 && coordinateSequence.getDimension() >= 3 && !Double.isNaN(d = coordinateSequence.getOrdinate(n, 3))) {
            writer.write(" ");
            writer.write(this.writeNumber(d));
        }
    }

    private void appendGeometryCollectionTaggedText(GeometryCollection geometryCollection, int n, Writer writer) throws IOException {
        writer.write("GEOMETRYCOLLECTION ");
        this.appendGeometryCollectionText(geometryCollection, n, writer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendGeometryCollectionText(GeometryCollection geometryCollection, int n, Writer writer) throws IOException {
        if (geometryCollection.isEmpty()) {
            writer.write("EMPTY");
            return;
        }
        writer.write("(");
        int n2 = 0;
        int n3 = n;
        while (true) {
            if (n2 >= geometryCollection.getNumGeometries()) {
                writer.write(")");
                return;
            }
            if (n2 > 0) {
                writer.write(", ");
                n3 = n + 1;
            }
            this.appendGeometryTaggedText(geometryCollection.getGeometryN(n2), n3, writer);
            ++n2;
        }
    }

    private void appendGeometryTaggedText(Geometry geometry, int n, Writer appendable) throws IOException {
        this.indent(n, (Writer)appendable);
        if (geometry instanceof Point) {
            geometry = (Point)geometry;
            this.appendPointTaggedText(((Point)geometry).getCoordinate(), n, (Writer)appendable, geometry.getPrecisionModel());
        } else if (geometry instanceof LinearRing) {
            this.appendLinearRingTaggedText((LinearRing)geometry, n, (Writer)appendable);
        } else if (geometry instanceof LineString) {
            this.appendLineStringTaggedText((LineString)geometry, n, (Writer)appendable);
        } else if (geometry instanceof Polygon) {
            this.appendPolygonTaggedText((Polygon)geometry, n, (Writer)appendable);
        } else if (geometry instanceof MultiPoint) {
            this.appendMultiPointTaggedText((MultiPoint)geometry, n, (Writer)appendable);
        } else if (geometry instanceof MultiLineString) {
            this.appendMultiLineStringTaggedText((MultiLineString)geometry, n, (Writer)appendable);
        } else if (geometry instanceof MultiPolygon) {
            this.appendMultiPolygonTaggedText((MultiPolygon)geometry, n, (Writer)appendable);
        } else if (geometry instanceof GeometryCollection) {
            this.appendGeometryCollectionTaggedText((GeometryCollection)geometry, n, (Writer)appendable);
        } else {
            appendable = new StringBuilder("Unsupported Geometry implementation:");
            ((StringBuilder)appendable).append(geometry.getClass());
            Assert.shouldNeverReachHere(((StringBuilder)appendable).toString());
        }
    }

    private void appendLineStringTaggedText(LineString lineString, int n, Writer writer) throws IOException {
        writer.write("LINESTRING ");
        this.appendLineStringText(lineString, n, false, writer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendLineStringText(LineString lineString, int n, boolean bl, Writer writer) throws IOException {
        if (lineString.isEmpty()) {
            writer.write("EMPTY");
            return;
        }
        if (bl) {
            this.indent(n, writer);
        }
        writer.write("(");
        int n2 = 0;
        while (true) {
            if (n2 >= lineString.getNumPoints()) {
                writer.write(")");
                return;
            }
            if (n2 > 0) {
                writer.write(", ");
                int n3 = this.coordsPerLine;
                if (n3 > 0 && n2 % n3 == 0) {
                    this.indent(n + 1, writer);
                }
            }
            this.appendCoordinate(lineString.getCoordinateN(n2), writer);
            ++n2;
        }
    }

    private void appendLinearRingTaggedText(LinearRing linearRing, int n, Writer writer) throws IOException {
        writer.write("LINEARRING ");
        this.appendLineStringText(linearRing, n, false, writer);
    }

    private void appendMultiLineStringTaggedText(MultiLineString multiLineString, int n, Writer writer) throws IOException {
        writer.write("MULTILINESTRING ");
        this.appendMultiLineStringText(multiLineString, n, false, writer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendMultiLineStringText(MultiLineString multiLineString, int n, boolean bl, Writer writer) throws IOException {
        if (multiLineString.isEmpty()) {
            writer.write("EMPTY");
            return;
        }
        writer.write("(");
        int n2 = 0;
        int n3 = n;
        while (true) {
            if (n2 >= multiLineString.getNumGeometries()) {
                writer.write(")");
                return;
            }
            if (n2 > 0) {
                writer.write(", ");
                n3 = n + 1;
                bl = true;
            }
            this.appendLineStringText((LineString)multiLineString.getGeometryN(n2), n3, bl, writer);
            ++n2;
        }
    }

    private void appendMultiPointTaggedText(MultiPoint multiPoint, int n, Writer writer) throws IOException {
        writer.write("MULTIPOINT ");
        this.appendMultiPointText(multiPoint, n, writer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendMultiPointText(MultiPoint multiPoint, int n, Writer writer) throws IOException {
        if (multiPoint.isEmpty()) {
            writer.write("EMPTY");
            return;
        }
        writer.write("(");
        int n2 = 0;
        while (true) {
            if (n2 >= multiPoint.getNumGeometries()) {
                writer.write(")");
                return;
            }
            if (n2 > 0) {
                writer.write(", ");
                this.indentCoords(n2, n + 1, writer);
            }
            writer.write("(");
            this.appendCoordinate(((Point)multiPoint.getGeometryN(n2)).getCoordinate(), writer);
            writer.write(")");
            ++n2;
        }
    }

    private void appendMultiPolygonTaggedText(MultiPolygon multiPolygon, int n, Writer writer) throws IOException {
        writer.write("MULTIPOLYGON ");
        this.appendMultiPolygonText(multiPolygon, n, writer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendMultiPolygonText(MultiPolygon multiPolygon, int n, Writer writer) throws IOException {
        if (multiPolygon.isEmpty()) {
            writer.write("EMPTY");
            return;
        }
        writer.write("(");
        int n2 = 0;
        int n3 = n;
        boolean bl = false;
        while (true) {
            if (n2 >= multiPolygon.getNumGeometries()) {
                writer.write(")");
                return;
            }
            if (n2 > 0) {
                writer.write(", ");
                n3 = n + 1;
                bl = true;
            }
            this.appendPolygonText((Polygon)multiPolygon.getGeometryN(n2), n3, bl, writer);
            ++n2;
        }
    }

    private void appendPointTaggedText(Coordinate coordinate, int n, Writer writer, PrecisionModel precisionModel) throws IOException {
        writer.write("POINT ");
        this.appendPointText(coordinate, n, writer, precisionModel);
    }

    private void appendPointText(Coordinate coordinate, int n, Writer writer, PrecisionModel precisionModel) throws IOException {
        if (coordinate == null) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            this.appendCoordinate(coordinate, writer);
            writer.write(")");
        }
    }

    private void appendPolygonTaggedText(Polygon polygon, int n, Writer writer) throws IOException {
        writer.write("POLYGON ");
        this.appendPolygonText(polygon, n, false, writer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendPolygonText(Polygon polygon, int n, boolean bl, Writer writer) throws IOException {
        if (polygon.isEmpty()) {
            writer.write("EMPTY");
            return;
        }
        if (bl) {
            this.indent(n, writer);
        }
        writer.write("(");
        LineString lineString = polygon.getExteriorRing();
        int n2 = 0;
        this.appendLineStringText(lineString, n, false, writer);
        while (true) {
            if (n2 >= polygon.getNumInteriorRing()) {
                writer.write(")");
                return;
            }
            writer.write(", ");
            this.appendLineStringText(polygon.getInteriorRingN(n2), n + 1, true, writer);
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendSequenceText(CoordinateSequence coordinateSequence, int n, boolean bl, Writer writer) throws IOException {
        if (coordinateSequence.size() == 0) {
            writer.write("EMPTY");
            return;
        }
        if (bl) {
            this.indent(n, writer);
        }
        writer.write("(");
        int n2 = 0;
        while (true) {
            if (n2 >= coordinateSequence.size()) {
                writer.write(")");
                return;
            }
            if (n2 > 0) {
                writer.write(", ");
                int n3 = this.coordsPerLine;
                if (n3 > 0 && n2 % n3 == 0) {
                    this.indent(n + 1, writer);
                }
            }
            this.appendCoordinate(coordinateSequence, n2, writer);
            ++n2;
        }
    }

    private static DecimalFormat createFormatter(PrecisionModel object) {
        int n = ((PrecisionModel)object).getMaximumSignificantDigits();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        StringBuilder stringBuilder = new StringBuilder("0");
        object = n > 0 ? "." : "";
        stringBuilder.append((String)object);
        stringBuilder.append(WKTWriter.stringOfChar('#', n));
        return new DecimalFormat(stringBuilder.toString(), decimalFormatSymbols);
    }

    private void indent(int n, Writer writer) throws IOException {
        if (this.useFormatting && n > 0) {
            writer.write("\n");
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                writer.write(this.indentTabStr);
                ++n2;
            }
        }
    }

    private void indentCoords(int n, int n2, Writer writer) throws IOException {
        int n3 = this.coordsPerLine;
        if (n3 > 0 && n % n3 == 0) {
            this.indent(n2, writer);
        }
    }

    public static String stringOfChar(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String toLineString(Coordinate coordinate, Coordinate coordinate2) {
        StringBuilder stringBuilder = new StringBuilder("LINESTRING ( ");
        stringBuilder.append(coordinate.x);
        stringBuilder.append(" ");
        stringBuilder.append(coordinate.y);
        stringBuilder.append(", ");
        stringBuilder.append(coordinate2.x);
        stringBuilder.append(" ");
        stringBuilder.append(coordinate2.y);
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toLineString(CoordinateSequence coordinateSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LINESTRING ");
        if (coordinateSequence.size() == 0) {
            stringBuffer.append(" EMPTY");
            return stringBuffer.toString();
        }
        stringBuffer.append("(");
        int n = 0;
        while (true) {
            if (n >= coordinateSequence.size()) {
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
            if (n > 0) {
                stringBuffer.append(", ");
            }
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(coordinateSequence.getX(n)));
            stringBuilder.append(" ");
            stringBuilder.append(coordinateSequence.getY(n));
            stringBuffer.append(stringBuilder.toString());
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toLineString(Coordinate[] coordinateArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LINESTRING ");
        if (coordinateArray.length == 0) {
            stringBuffer.append(" EMPTY");
            return stringBuffer.toString();
        }
        stringBuffer.append("(");
        int n = 0;
        while (true) {
            if (n >= coordinateArray.length) {
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
            if (n > 0) {
                stringBuffer.append(", ");
            }
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(coordinateArray[n].x));
            stringBuilder.append(" ");
            stringBuilder.append(coordinateArray[n].y);
            stringBuffer.append(stringBuilder.toString());
            ++n;
        }
    }

    public static String toPoint(Coordinate coordinate) {
        StringBuilder stringBuilder = new StringBuilder("POINT ( ");
        stringBuilder.append(coordinate.x);
        stringBuilder.append(" ");
        stringBuilder.append(coordinate.y);
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    private void writeFormatted(Geometry geometry, boolean bl, Writer writer) throws IOException {
        this.useFormatting = bl;
        this.formatter = WKTWriter.createFormatter(geometry.getPrecisionModel());
        this.appendGeometryTaggedText(geometry, 0, writer);
    }

    private String writeNumber(double d) {
        return this.formatter.format(d);
    }

    public void setFormatted(boolean bl) {
        this.isFormatted = bl;
    }

    public void setMaxCoordinatesPerLine(int n) {
        this.coordsPerLine = n;
    }

    public void setTab(int n) {
        if (n > 0) {
            this.indentTabStr = WKTWriter.stringOfChar(' ', n);
            return;
        }
        throw new IllegalArgumentException("Tab count must be positive");
    }

    public String write(Geometry geometry) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.writeFormatted(geometry, this.isFormatted, stringWriter);
        }
        catch (IOException iOException) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)stringWriter).toString();
    }

    public void write(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, false, writer);
    }

    public String writeFormatted(Geometry geometry) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.writeFormatted(geometry, true, stringWriter);
        }
        catch (IOException iOException) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)stringWriter).toString();
    }

    public void writeFormatted(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, true, writer);
    }
}

