/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.linearref.LinearGeometryBuilder;
import com.vividsolutions.jts.linearref.LinearIterator;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.util.Assert;

class ExtractLineByLocation {
    private Geometry line;

    public ExtractLineByLocation(Geometry geometry) {
        this.line = geometry;
    }

    private LineString computeLine(LinearLocation coordinateArray, LinearLocation coordinateArray2) {
        int n;
        int n2;
        Coordinate[] coordinateArray3 = this.line.getCoordinates();
        CoordinateList coordinateList = new CoordinateList();
        int n3 = n2 = coordinateArray.getSegmentIndex();
        if (coordinateArray.getSegmentFraction() > 0.0) {
            n3 = n2 + 1;
        }
        n2 = n = coordinateArray2.getSegmentIndex();
        if (coordinateArray2.getSegmentFraction() == 1.0) {
            n2 = n + 1;
        }
        n = n2;
        if (n2 >= coordinateArray3.length) {
            n = coordinateArray3.length - 1;
        }
        n2 = n3;
        if (!coordinateArray.isVertex()) {
            coordinateList.add(coordinateArray.getCoordinate(this.line));
            n2 = n3;
        }
        while (true) {
            if (n2 > n) {
                if (!coordinateArray2.isVertex()) {
                    coordinateList.add(coordinateArray2.getCoordinate(this.line));
                }
                if (coordinateList.size() <= 0) {
                    coordinateList.add(coordinateArray.getCoordinate(this.line));
                }
                coordinateArray = coordinateArray2 = coordinateList.toCoordinateArray();
                if (coordinateArray2.length <= 1) {
                    coordinateArray = new Coordinate[]{coordinateArray2[0], coordinateArray2[0]};
                }
                return this.line.getFactory().createLineString(coordinateArray);
            }
            coordinateList.add(coordinateArray3[n2]);
            ++n2;
        }
    }

    private Geometry computeLinear(LinearLocation object, LinearLocation linearLocation) {
        LinearGeometryBuilder linearGeometryBuilder = new LinearGeometryBuilder(this.line.getFactory());
        linearGeometryBuilder.setFixInvalidLines(true);
        if (!((LinearLocation)object).isVertex()) {
            linearGeometryBuilder.add(((LinearLocation)object).getCoordinate(this.line));
        }
        object = new LinearIterator(this.line, (LinearLocation)object);
        while (true) {
            if (!((LinearIterator)object).hasNext() || linearLocation.compareLocationValues(((LinearIterator)object).getComponentIndex(), ((LinearIterator)object).getVertexIndex(), 0.0) < 0) {
                if (!linearLocation.isVertex()) {
                    linearGeometryBuilder.add(linearLocation.getCoordinate(this.line));
                }
                return linearGeometryBuilder.getGeometry();
            }
            linearGeometryBuilder.add(((LinearIterator)object).getSegmentStart());
            if (((LinearIterator)object).isEndOfLine()) {
                linearGeometryBuilder.endLine();
            }
            ((LinearIterator)object).next();
        }
    }

    public static Geometry extract(Geometry geometry, LinearLocation linearLocation, LinearLocation linearLocation2) {
        return new ExtractLineByLocation(geometry).extract(linearLocation, linearLocation2);
    }

    private Geometry reverse(Geometry geometry) {
        if (geometry instanceof LineString) {
            return ((LineString)geometry).reverse();
        }
        if (geometry instanceof MultiLineString) {
            return ((MultiLineString)geometry).reverse();
        }
        Assert.shouldNeverReachHere("non-linear geometry encountered");
        return null;
    }

    public Geometry extract(LinearLocation linearLocation, LinearLocation linearLocation2) {
        if (linearLocation2.compareTo(linearLocation) < 0) {
            return this.reverse(this.computeLinear(linearLocation2, linearLocation));
        }
        return this.computeLinear(linearLocation, linearLocation2);
    }
}

