/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.linearref.ExtractLineByLocation;
import com.vividsolutions.jts.linearref.LengthIndexOfPoint;
import com.vividsolutions.jts.linearref.LengthLocationMap;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexOfLine;
import com.vividsolutions.jts.linearref.LocationIndexedLine;

public class LengthIndexedLine {
    private Geometry linearGeom;

    public LengthIndexedLine(Geometry geometry) {
        this.linearGeom = geometry;
    }

    private LinearLocation locationOf(double d) {
        return LengthLocationMap.getLocation(this.linearGeom, d);
    }

    private LinearLocation locationOf(double d, boolean bl) {
        return LengthLocationMap.getLocation(this.linearGeom, d, bl);
    }

    private double positiveIndex(double d) {
        if (d >= 0.0) {
            return d;
        }
        return this.linearGeom.getLength() + d;
    }

    public double clampIndex(double d) {
        double d2;
        if ((d = this.positiveIndex(d)) < (d2 = this.getStartIndex())) {
            return d2;
        }
        d2 = this.getEndIndex();
        if (d > d2) {
            return d2;
        }
        return d;
    }

    public Geometry extractLine(double d, double d2) {
        new LocationIndexedLine(this.linearGeom);
        d = this.clampIndex(d);
        d2 = this.clampIndex(d2);
        boolean bl = d == d2;
        LinearLocation linearLocation = this.locationOf(d, bl);
        LinearLocation linearLocation2 = this.locationOf(d2);
        return ExtractLineByLocation.extract(this.linearGeom, linearLocation, linearLocation2);
    }

    public Coordinate extractPoint(double d) {
        return LengthLocationMap.getLocation(this.linearGeom, d).getCoordinate(this.linearGeom);
    }

    public Coordinate extractPoint(double d, double d2) {
        LinearLocation linearLocation = LengthLocationMap.getLocation(this.linearGeom, d).toLowest(this.linearGeom);
        return linearLocation.getSegment(this.linearGeom).pointAlongOffset(linearLocation.getSegmentFraction(), d2);
    }

    public double getEndIndex() {
        return this.linearGeom.getLength();
    }

    public double getStartIndex() {
        return 0.0;
    }

    public double indexOf(Coordinate coordinate) {
        return LengthIndexOfPoint.indexOf(this.linearGeom, coordinate);
    }

    public double indexOfAfter(Coordinate coordinate, double d) {
        return LengthIndexOfPoint.indexOfAfter(this.linearGeom, coordinate, d);
    }

    public double[] indicesOf(Geometry linearLocationArray) {
        linearLocationArray = LocationIndexOfLine.indicesOf(this.linearGeom, (Geometry)linearLocationArray);
        return new double[]{LengthLocationMap.getLength(this.linearGeom, linearLocationArray[0]), LengthLocationMap.getLength(this.linearGeom, linearLocationArray[1])};
    }

    public boolean isValidIndex(double d) {
        return d >= this.getStartIndex() && d <= this.getEndIndex();
    }

    public double project(Coordinate coordinate) {
        return LengthIndexOfPoint.indexOf(this.linearGeom, coordinate);
    }
}

