/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.linearref.LinearLocation;

public class LinearIterator {
    private int componentIndex = 0;
    private LineString currentLine;
    private Geometry linearGeom;
    private final int numLines;
    private int vertexIndex = 0;

    public LinearIterator(Geometry geometry) {
        this(geometry, 0, 0);
    }

    public LinearIterator(Geometry geometry, int n, int n2) {
        if (geometry instanceof Lineal) {
            this.linearGeom = geometry;
            this.numLines = geometry.getNumGeometries();
            this.componentIndex = n;
            this.vertexIndex = n2;
            this.loadCurrentLine();
            return;
        }
        throw new IllegalArgumentException("Lineal geometry is required");
    }

    public LinearIterator(Geometry geometry, LinearLocation linearLocation) {
        this(geometry, linearLocation.getComponentIndex(), LinearIterator.segmentEndVertexIndex(linearLocation));
    }

    private void loadCurrentLine() {
        int n = this.componentIndex;
        if (n >= this.numLines) {
            this.currentLine = null;
            return;
        }
        this.currentLine = (LineString)this.linearGeom.getGeometryN(n);
    }

    private static int segmentEndVertexIndex(LinearLocation linearLocation) {
        if (linearLocation.getSegmentFraction() > 0.0) {
            return linearLocation.getSegmentIndex() + 1;
        }
        return linearLocation.getSegmentIndex();
    }

    public int getComponentIndex() {
        return this.componentIndex;
    }

    public LineString getLine() {
        return this.currentLine;
    }

    public Coordinate getSegmentEnd() {
        if (this.vertexIndex < this.getLine().getNumPoints() - 1) {
            return this.currentLine.getCoordinateN(this.vertexIndex + 1);
        }
        return null;
    }

    public Coordinate getSegmentStart() {
        return this.currentLine.getCoordinateN(this.vertexIndex);
    }

    public int getVertexIndex() {
        return this.vertexIndex;
    }

    public boolean hasNext() {
        int n = this.componentIndex;
        int n2 = this.numLines;
        if (n >= n2) {
            return false;
        }
        return n != n2 - 1 || this.vertexIndex < this.currentLine.getNumPoints();
    }

    public boolean isEndOfLine() {
        if (this.componentIndex >= this.numLines) {
            return false;
        }
        return this.vertexIndex >= this.currentLine.getNumPoints() - 1;
    }

    public void next() {
        int n;
        if (!this.hasNext()) {
            return;
        }
        this.vertexIndex = n = this.vertexIndex + 1;
        if (n >= this.currentLine.getNumPoints()) {
            ++this.componentIndex;
            this.loadCurrentLine();
            this.vertexIndex = 0;
        }
    }
}

