/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;

public class LinearLocation
implements Comparable {
    private int componentIndex = 0;
    private double segmentFraction = 0.0;
    private int segmentIndex = 0;

    public LinearLocation() {
    }

    public LinearLocation(int n, double d) {
        this(0, n, d);
    }

    public LinearLocation(int n, int n2, double d) {
        this.componentIndex = n;
        this.segmentIndex = n2;
        this.segmentFraction = d;
        this.normalize();
    }

    private LinearLocation(int n, int n2, double d, boolean bl) {
        this.componentIndex = n;
        this.segmentIndex = n2;
        this.segmentFraction = d;
        if (bl) {
            this.normalize();
        }
    }

    public LinearLocation(LinearLocation linearLocation) {
        this.componentIndex = linearLocation.componentIndex;
        this.segmentIndex = linearLocation.segmentIndex;
        this.segmentFraction = linearLocation.segmentFraction;
    }

    public static int compareLocationValues(int n, int n2, double d, int n3, int n4, double d2) {
        if (n < n3) {
            return -1;
        }
        if (n > n3) {
            return 1;
        }
        if (n2 < n4) {
            return -1;
        }
        if (n2 > n4) {
            return 1;
        }
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        return 0;
    }

    public static LinearLocation getEndLocation(Geometry geometry) {
        LinearLocation linearLocation = new LinearLocation();
        linearLocation.setToEnd(geometry);
        return linearLocation;
    }

    private void normalize() {
        if (this.segmentFraction < 0.0) {
            this.segmentFraction = 0.0;
        }
        if (this.segmentFraction > 1.0) {
            this.segmentFraction = 1.0;
        }
        if (this.componentIndex < 0) {
            this.componentIndex = 0;
            this.segmentIndex = 0;
            this.segmentFraction = 0.0;
        }
        if (this.segmentIndex < 0) {
            this.segmentIndex = 0;
            this.segmentFraction = 0.0;
        }
        if (this.segmentFraction == 1.0) {
            this.segmentFraction = 0.0;
            ++this.segmentIndex;
        }
    }

    public static Coordinate pointAlongSegmentByFraction(Coordinate coordinate, Coordinate coordinate2, double d) {
        if (d <= 0.0) {
            return coordinate;
        }
        if (d >= 1.0) {
            return coordinate2;
        }
        return new Coordinate((coordinate2.x - coordinate.x) * d + coordinate.x, (coordinate2.y - coordinate.y) * d + coordinate.y, (coordinate2.z - coordinate.z) * d + coordinate.z);
    }

    public void clamp(Geometry geometry) {
        if (this.componentIndex >= geometry.getNumGeometries()) {
            this.setToEnd(geometry);
            return;
        }
        if (this.segmentIndex >= geometry.getNumPoints()) {
            this.segmentIndex = ((LineString)geometry.getGeometryN(this.componentIndex)).getNumPoints() - 1;
            this.segmentFraction = 1.0;
        }
    }

    public Object clone() {
        return new LinearLocation(this.componentIndex, this.segmentIndex, this.segmentFraction);
    }

    public int compareLocationValues(int n, int n2, double d) {
        int n3 = this.componentIndex;
        if (n3 < n) {
            return -1;
        }
        if (n3 > n) {
            return 1;
        }
        n = this.segmentIndex;
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        double d2 = this.segmentFraction;
        if (d2 < d) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object object) {
        object = (LinearLocation)object;
        int n = this.componentIndex;
        int n2 = ((LinearLocation)object).componentIndex;
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        n = this.segmentIndex;
        n2 = ((LinearLocation)object).segmentIndex;
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        double d = this.segmentFraction;
        double d2 = ((LinearLocation)object).segmentFraction;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        return 0;
    }

    public int getComponentIndex() {
        return this.componentIndex;
    }

    public Coordinate getCoordinate(Geometry geometry) {
        geometry = (LineString)geometry.getGeometryN(this.componentIndex);
        Coordinate coordinate = ((LineString)geometry).getCoordinateN(this.segmentIndex);
        if (this.segmentIndex >= ((LineString)geometry).getNumPoints() - 1) {
            return coordinate;
        }
        return LinearLocation.pointAlongSegmentByFraction(coordinate, ((LineString)geometry).getCoordinateN(this.segmentIndex + 1), this.segmentFraction);
    }

    public LineSegment getSegment(Geometry comparable) {
        LineString lineString = (LineString)comparable.getGeometryN(this.componentIndex);
        comparable = lineString.getCoordinateN(this.segmentIndex);
        if (this.segmentIndex >= lineString.getNumPoints() - 1) {
            return new LineSegment(lineString.getCoordinateN(lineString.getNumPoints() - 2), (Coordinate)comparable);
        }
        return new LineSegment((Coordinate)comparable, lineString.getCoordinateN(this.segmentIndex + 1));
    }

    public double getSegmentFraction() {
        return this.segmentFraction;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public double getSegmentLength(Geometry geometry) {
        int n;
        geometry = (LineString)geometry.getGeometryN(this.componentIndex);
        int n2 = n = this.segmentIndex;
        if (n >= ((LineString)geometry).getNumPoints() - 1) {
            n2 = ((LineString)geometry).getNumPoints() - 2;
        }
        return ((LineString)geometry).getCoordinateN(n2).distance(((LineString)geometry).getCoordinateN(n2 + 1));
    }

    public boolean isEndpoint(Geometry geometry) {
        int n = this.segmentIndex;
        int n2 = ((LineString)geometry.getGeometryN(this.componentIndex)).getNumPoints() - 1;
        return n >= n2 || n == n2 && this.segmentFraction >= 1.0;
    }

    public boolean isOnSameSegment(LinearLocation linearLocation) {
        if (this.componentIndex != linearLocation.componentIndex) {
            return false;
        }
        int n = this.segmentIndex;
        int n2 = linearLocation.segmentIndex;
        if (n == n2) {
            return true;
        }
        if (n2 - n == 1 && linearLocation.segmentFraction == 0.0) {
            return true;
        }
        return n - n2 == 1 && this.segmentFraction == 0.0;
    }

    public boolean isValid(Geometry geometry) {
        int n = this.componentIndex;
        if (n >= 0 && n < geometry.getNumGeometries()) {
            geometry = (LineString)geometry.getGeometryN(this.componentIndex);
            n = this.segmentIndex;
            if (n >= 0 && n <= ((LineString)geometry).getNumPoints()) {
                if (this.segmentIndex == ((LineString)geometry).getNumPoints() && this.segmentFraction != 0.0) {
                    return false;
                }
                double d = this.segmentFraction;
                if (!(d < 0.0) && !(d > 1.0)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isVertex() {
        double d = this.segmentFraction;
        return d <= 0.0 || d >= 1.0;
    }

    public void setToEnd(Geometry geometry) {
        int n;
        this.componentIndex = n = geometry.getNumGeometries() - 1;
        this.segmentIndex = ((LineString)geometry.getGeometryN(n)).getNumPoints() - 1;
        this.segmentFraction = 1.0;
    }

    public void snapToVertex(Geometry geometry, double d) {
        double d2 = this.segmentFraction;
        if (!(d2 <= 0.0) && !(d2 >= 1.0)) {
            double d3 = this.getSegmentLength(geometry);
            d2 = this.segmentFraction * d3;
            if (d2 <= (d3 -= d2) && d2 < d) {
                this.segmentFraction = 0.0;
            } else if (d3 <= d2 && d3 < d) {
                this.segmentFraction = 1.0;
            }
        }
    }

    public LinearLocation toLowest(Geometry geometry) {
        int n = ((LineString)geometry.getGeometryN(this.componentIndex)).getNumPoints() - 1;
        if (this.segmentIndex < n) {
            return this;
        }
        return new LinearLocation(this.componentIndex, n, 1.0, false);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LinearLoc[");
        stringBuilder.append(this.componentIndex);
        stringBuilder.append(", ");
        stringBuilder.append(this.segmentIndex);
        stringBuilder.append(", ");
        stringBuilder.append(this.segmentFraction);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

