/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.math;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.math.Vector3D;

public class Plane3D {
    public static final int XY_PLANE = 1;
    public static final int XZ_PLANE = 3;
    public static final int YZ_PLANE = 2;
    private Coordinate basePt;
    private Vector3D normal;

    public Plane3D(Vector3D vector3D, Coordinate coordinate) {
        this.normal = vector3D;
        this.basePt = coordinate;
    }

    public int closestAxisPlane() {
        double d = Math.abs(this.normal.getX());
        double d2 = Math.abs(this.normal.getY());
        double d3 = Math.abs(this.normal.getZ());
        if (d > d2) {
            if (d > d3) {
                return 2;
            }
            return 1;
        }
        if (d3 > d2) {
            return 1;
        }
        return 3;
    }

    public double orientedDistance(Coordinate coordinate) {
        double d = new Vector3D(coordinate, this.basePt).dot(this.normal);
        if (!Double.isNaN(d)) {
            return d / this.normal.length();
        }
        throw new IllegalArgumentException("3D Coordinate has NaN ordinate");
    }
}

