/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.math;

import com.vividsolutions.jts.geom.Coordinate;

public class Vector3D {
    private double x;
    private double y;
    private double z;

    public Vector3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3D(Coordinate coordinate) {
        this.x = coordinate.x;
        this.y = coordinate.y;
        this.z = coordinate.z;
    }

    public Vector3D(Coordinate coordinate, Coordinate coordinate2) {
        this.x = coordinate2.x - coordinate.x;
        this.y = coordinate2.y - coordinate.y;
        this.z = coordinate2.z - coordinate.z;
    }

    public static Vector3D create(double d, double d2, double d3) {
        return new Vector3D(d, d2, d3);
    }

    public static Vector3D create(Coordinate coordinate) {
        return new Vector3D(coordinate);
    }

    private Vector3D divide(double d) {
        return Vector3D.create(this.x / d, this.y / d, this.z / d);
    }

    public static double dot(Coordinate coordinate, Coordinate coordinate2) {
        return coordinate.x * coordinate2.x + coordinate.y * coordinate2.y + coordinate.z * coordinate2.z;
    }

    public static double dot(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        double d = coordinate2.x;
        double d2 = coordinate.x;
        double d3 = coordinate2.y;
        double d4 = coordinate.y;
        double d5 = coordinate2.z;
        double d6 = coordinate.z;
        return (d - d2) * (coordinate4.x - coordinate3.x) + (d3 - d4) * (coordinate4.y - coordinate3.y) + (d5 - d6) * (coordinate4.z - coordinate3.z);
    }

    public static double length(Coordinate coordinate) {
        return Math.sqrt(coordinate.x * coordinate.x + coordinate.y * coordinate.y + coordinate.z * coordinate.z);
    }

    public static Coordinate normalize(Coordinate coordinate) {
        double d = Vector3D.length(coordinate);
        return new Coordinate(coordinate.x / d, coordinate.y / d, coordinate.z / d);
    }

    public double dot(Vector3D vector3D) {
        return this.x * vector3D.x + this.y * vector3D.y + this.z * vector3D.z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double length() {
        double d = this.x;
        double d2 = this.y;
        double d3 = this.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public Vector3D normalize() {
        if (this.length() > 0.0) {
            return this.divide(this.length());
        }
        return Vector3D.create(0.0, 0.0, 0.0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append(this.x);
        stringBuilder.append(", ");
        stringBuilder.append(this.y);
        stringBuilder.append(", ");
        stringBuilder.append(this.z);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

