/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.noding.Octant;
import com.vividsolutions.jts.noding.SegmentString;

public class BasicSegmentString
implements SegmentString {
    private Object data;
    private Coordinate[] pts;

    public BasicSegmentString(Coordinate[] coordinateArray, Object object) {
        this.pts = coordinateArray;
        this.data = object;
    }

    @Override
    public Coordinate getCoordinate(int n) {
        return this.pts[n];
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public int getSegmentOctant(int n) {
        if (n == this.pts.length - 1) {
            return -1;
        }
        return Octant.octant(this.getCoordinate(n), this.getCoordinate(n + 1));
    }

    @Override
    public boolean isClosed() {
        Coordinate[] coordinateArray = this.pts;
        return coordinateArray[0].equals(coordinateArray[coordinateArray.length - 1]);
    }

    @Override
    public void setData(Object object) {
        this.data = object;
    }

    @Override
    public int size() {
        return this.pts.length;
    }

    public String toString() {
        return WKTWriter.toLineString(new CoordinateArraySequence(this.pts));
    }
}

