/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.noding.InteriorIntersectionFinder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.SinglePassNoder;
import java.util.Collection;
import java.util.List;

public class FastNodingValidator {
    private boolean findAllIntersections = false;
    private boolean isValid = true;
    private LineIntersector li = new RobustLineIntersector();
    private InteriorIntersectionFinder segInt = null;
    private Collection segStrings;

    public FastNodingValidator(Collection collection) {
        this.segStrings = collection;
    }

    private void checkInteriorIntersections() {
        this.isValid = true;
        Object object = new InteriorIntersectionFinder(this.li);
        this.segInt = object;
        ((InteriorIntersectionFinder)object).setFindAllIntersections(this.findAllIntersections);
        object = new MCIndexNoder();
        ((SinglePassNoder)object).setSegmentIntersector(this.segInt);
        ((MCIndexNoder)object).computeNodes(this.segStrings);
        if (this.segInt.hasIntersection()) {
            this.isValid = false;
        }
    }

    public static List computeIntersections(Collection object) {
        object = new FastNodingValidator((Collection)object);
        ((FastNodingValidator)object).setFindAllIntersections(true);
        ((FastNodingValidator)object).isValid();
        return ((FastNodingValidator)object).getIntersections();
    }

    private void execute() {
        if (this.segInt != null) {
            return;
        }
        this.checkInteriorIntersections();
    }

    public void checkValid() {
        this.execute();
        if (this.isValid) {
            return;
        }
        throw new TopologyException(this.getErrorMessage(), this.segInt.getInteriorIntersection());
    }

    public String getErrorMessage() {
        if (this.isValid) {
            return "no intersections found";
        }
        Coordinate[] coordinateArray = this.segInt.getIntersectionSegments();
        StringBuilder stringBuilder = new StringBuilder("found non-noded intersection between ");
        stringBuilder.append(WKTWriter.toLineString(coordinateArray[0], coordinateArray[1]));
        stringBuilder.append(" and ");
        stringBuilder.append(WKTWriter.toLineString(coordinateArray[2], coordinateArray[3]));
        return stringBuilder.toString();
    }

    public List getIntersections() {
        return this.segInt.getIntersections();
    }

    public boolean isValid() {
        this.execute();
        return this.isValid;
    }

    public void setFindAllIntersections(boolean bl) {
        this.findAllIntersections = bl;
    }
}

