/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.List;

public class InteriorIntersectionFinder
implements SegmentIntersector {
    private boolean findAllIntersections = false;
    private Coordinate[] intSegments = null;
    private Coordinate interiorIntersection = null;
    private int intersectionCount = 0;
    private List intersections = new ArrayList();
    private boolean isCheckEndSegmentsOnly = false;
    private boolean keepIntersections = true;
    private LineIntersector li;

    public InteriorIntersectionFinder(LineIntersector lineIntersector) {
        this.li = lineIntersector;
        this.interiorIntersection = null;
    }

    public static InteriorIntersectionFinder createAllIntersectionsFinder(LineIntersector object) {
        object = new InteriorIntersectionFinder((LineIntersector)object);
        ((InteriorIntersectionFinder)object).setFindAllIntersections(true);
        return object;
    }

    public static InteriorIntersectionFinder createAnyIntersectionFinder(LineIntersector lineIntersector) {
        return new InteriorIntersectionFinder(lineIntersector);
    }

    public static InteriorIntersectionFinder createIntersectionCounter(LineIntersector object) {
        object = new InteriorIntersectionFinder((LineIntersector)object);
        ((InteriorIntersectionFinder)object).setFindAllIntersections(true);
        ((InteriorIntersectionFinder)object).setKeepIntersections(false);
        return object;
    }

    private boolean isEndSegment(SegmentString segmentString, int n) {
        if (n == 0) {
            return true;
        }
        return n >= segmentString.size() - 2;
    }

    public int count() {
        return this.intersectionCount;
    }

    public Coordinate getInteriorIntersection() {
        return this.interiorIntersection;
    }

    public Coordinate[] getIntersectionSegments() {
        return this.intSegments;
    }

    public List getIntersections() {
        return this.intersections;
    }

    public boolean hasIntersection() {
        return this.interiorIntersection != null;
    }

    @Override
    public boolean isDone() {
        if (this.findAllIntersections) {
            return false;
        }
        return this.interiorIntersection != null;
    }

    @Override
    public void processIntersections(SegmentString object, int n, SegmentString object2, int n2) {
        boolean bl;
        if (!this.findAllIntersections && this.hasIntersection()) {
            return;
        }
        if (object == object2 && n == n2) {
            return;
        }
        if (this.isCheckEndSegmentsOnly && !(bl = this.isEndSegment((SegmentString)object, n) || this.isEndSegment((SegmentString)object2, n2))) {
            return;
        }
        Coordinate coordinate = object.getCoordinates()[n];
        Coordinate coordinate2 = object.getCoordinates()[n + 1];
        object = object2.getCoordinates()[n2];
        object2 = object2.getCoordinates()[n2 + 1];
        this.li.computeIntersection(coordinate, coordinate2, (Coordinate)object, (Coordinate)object2);
        if (this.li.hasIntersection() && this.li.isInteriorIntersection()) {
            Coordinate[] coordinateArray = new Coordinate[4];
            this.intSegments = coordinateArray;
            coordinateArray[0] = coordinate;
            coordinateArray[1] = coordinate2;
            coordinateArray[2] = object;
            coordinateArray[3] = object2;
            this.interiorIntersection = object = this.li.getIntersection(0);
            if (this.keepIntersections) {
                this.intersections.add(object);
            }
            ++this.intersectionCount;
        }
    }

    public void setCheckEndSegmentsOnly(boolean bl) {
        this.isCheckEndSegmentsOnly = bl;
    }

    public void setFindAllIntersections(boolean bl) {
        this.findAllIntersections = bl;
    }

    public void setKeepIntersections(boolean bl) {
        this.keepIntersections = bl;
    }
}

