/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;

public class IntersectionAdder
implements SegmentIntersector {
    private boolean hasInterior = false;
    private boolean hasIntersection = false;
    private boolean hasProper = false;
    private boolean hasProperInterior = false;
    private boolean isSelfIntersection;
    private LineIntersector li;
    public int numInteriorIntersections = 0;
    public int numIntersections = 0;
    public int numProperIntersections = 0;
    public int numTests = 0;
    private Coordinate properIntersectionPoint = null;

    public IntersectionAdder(LineIntersector lineIntersector) {
        this.li = lineIntersector;
    }

    public static boolean isAdjacentSegments(int n, int n2) {
        return Math.abs(n - n2) == 1;
    }

    private boolean isTrivialIntersection(SegmentString segmentString, int n, SegmentString segmentString2, int n2) {
        if (segmentString == segmentString2 && this.li.getIntersectionNum() == 1) {
            if (IntersectionAdder.isAdjacentSegments(n, n2)) {
                return true;
            }
            if (segmentString.isClosed()) {
                int n3 = segmentString.size() - 1;
                if (n == 0 && n2 == n3 || n2 == 0 && n == n3) {
                    return true;
                }
            }
        }
        return false;
    }

    public LineIntersector getLineIntersector() {
        return this.li;
    }

    public Coordinate getProperIntersectionPoint() {
        return this.properIntersectionPoint;
    }

    public boolean hasInteriorIntersection() {
        return this.hasInterior;
    }

    public boolean hasIntersection() {
        return this.hasIntersection;
    }

    public boolean hasProperInteriorIntersection() {
        return this.hasProperInterior;
    }

    public boolean hasProperIntersection() {
        return this.hasProper;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void processIntersections(SegmentString segmentString, int n, SegmentString segmentString2, int n2) {
        if (segmentString == segmentString2 && n == n2) {
            return;
        }
        ++this.numTests;
        Coordinate coordinate = segmentString.getCoordinates()[n];
        Coordinate coordinate2 = segmentString.getCoordinates()[n + 1];
        Coordinate coordinate3 = segmentString2.getCoordinates()[n2];
        Coordinate coordinate4 = segmentString2.getCoordinates()[n2 + 1];
        this.li.computeIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        if (this.li.hasIntersection()) {
            ++this.numIntersections;
            if (this.li.isInteriorIntersection()) {
                ++this.numInteriorIntersections;
                this.hasInterior = true;
            }
            if (!this.isTrivialIntersection(segmentString, n, segmentString2, n2)) {
                this.hasIntersection = true;
                ((NodedSegmentString)segmentString).addIntersections(this.li, n, 0);
                ((NodedSegmentString)segmentString2).addIntersections(this.li, n2, 1);
                if (this.li.isProper()) {
                    ++this.numProperIntersections;
                    this.hasProper = true;
                    this.hasProperInterior = true;
                }
            }
        }
    }
}

