/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.noding.IntersectionAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.Noder;
import java.util.Collection;

public class IteratedNoder
implements Noder {
    public static final int MAX_ITER = 5;
    private LineIntersector li;
    private int maxIter = 5;
    private Collection nodedSegStrings;
    private PrecisionModel pm;

    public IteratedNoder(PrecisionModel precisionModel) {
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        this.li = robustLineIntersector;
        this.pm = precisionModel;
        robustLineIntersector.setPrecisionModel(precisionModel);
    }

    private void node(Collection collection, int[] nArray) {
        IntersectionAdder intersectionAdder = new IntersectionAdder(this.li);
        MCIndexNoder mCIndexNoder = new MCIndexNoder();
        mCIndexNoder.setSegmentIntersector(intersectionAdder);
        mCIndexNoder.computeNodes(collection);
        this.nodedSegStrings = mCIndexNoder.getNodedSubstrings();
        nArray[0] = intersectionAdder.numInteriorIntersections;
    }

    @Override
    public void computeNodes(Collection object) throws TopologyException {
        int[] nArray = new int[1];
        this.nodedSegStrings = object;
        int n = -1;
        int n2 = 0;
        while (true) {
            this.node(this.nodedSegStrings, nArray);
            int n3 = nArray[0];
            if (n > 0 && n3 >= n && ++n2 > this.maxIter) {
                object = new StringBuilder("Iterated noding failed to converge after ");
                ((StringBuilder)object).append(n2);
                ((StringBuilder)object).append(" iterations");
                throw new TopologyException(((StringBuilder)object).toString());
            }
            if (n3 <= 0) {
                return;
            }
            n = n3;
        }
    }

    @Override
    public Collection getNodedSubstrings() {
        return this.nodedSegStrings;
    }

    public void setMaximumIterations(int n) {
        this.maxIter = n;
    }
}

