/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.util.Debug;
import java.util.Collection;
import java.util.Iterator;

public class NodingValidator {
    private LineIntersector li = new RobustLineIntersector();
    private Collection segStrings;

    public NodingValidator(Collection collection) {
        this.segStrings = collection;
    }

    private void checkCollapse(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        if (!coordinate.equals(coordinate3)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("found non-noded collapse at ");
        stringBuilder.append(Debug.toLine(coordinate, coordinate2, coordinate3));
        throw new RuntimeException(stringBuilder.toString());
    }

    private void checkCollapses() {
        Iterator iterator2 = this.segStrings.iterator();
        while (iterator2.hasNext()) {
            this.checkCollapses((SegmentString)iterator2.next());
        }
        return;
    }

    private void checkCollapses(SegmentString object) {
        Coordinate[] coordinateArray = object.getCoordinates();
        int n = 0;
        while (n < coordinateArray.length - 2) {
            object = coordinateArray[n];
            int n2 = n + 1;
            this.checkCollapse((Coordinate)object, coordinateArray[n2], coordinateArray[n + 2]);
            n = n2;
        }
        return;
    }

    private void checkEndPtVertexIntersections() {
        Iterator iterator2 = this.segStrings.iterator();
        while (iterator2.hasNext()) {
            Coordinate[] coordinateArray = ((SegmentString)iterator2.next()).getCoordinates();
            this.checkEndPtVertexIntersections(coordinateArray[0], this.segStrings);
            this.checkEndPtVertexIntersections(coordinateArray[coordinateArray.length - 1], this.segStrings);
        }
        return;
    }

    private void checkEndPtVertexIntersections(Coordinate coordinate, Collection object) {
        int n;
        object = object.iterator();
        block0: while (true) {
            if (!object.hasNext()) {
                return;
            }
            Coordinate[] coordinateArray = ((SegmentString)object.next()).getCoordinates();
            n = 1;
            while (true) {
                if (n >= coordinateArray.length - 1) continue block0;
                if (coordinateArray[n].equals(coordinate)) break block0;
                ++n;
            }
            break;
        }
        object = new StringBuilder("found endpt/interior pt intersection at index ");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append(" :pt ");
        ((StringBuilder)object).append(coordinate);
        throw new RuntimeException(((StringBuilder)object).toString());
    }

    private void checkInteriorIntersections() {
        Iterator iterator2 = this.segStrings.iterator();
        block0: while (iterator2.hasNext()) {
            SegmentString segmentString = (SegmentString)iterator2.next();
            Iterator iterator3 = this.segStrings.iterator();
            while (true) {
                if (!iterator3.hasNext()) continue block0;
                this.checkInteriorIntersections(segmentString, (SegmentString)iterator3.next());
            }
            break;
        }
        return;
    }

    private void checkInteriorIntersections(SegmentString object, int n, SegmentString object2, int n2) {
        if (object == object2 && n == n2) {
            return;
        }
        Coordinate coordinate = object.getCoordinates()[n];
        object = object.getCoordinates()[n + 1];
        Coordinate coordinate2 = object2.getCoordinates()[n2];
        object2 = object2.getCoordinates()[n2 + 1];
        this.li.computeIntersection(coordinate, (Coordinate)object, coordinate2, (Coordinate)object2);
        if (this.li.hasIntersection() && (this.li.isProper() || this.hasInteriorIntersection(this.li, coordinate, (Coordinate)object) || this.hasInteriorIntersection(this.li, coordinate2, (Coordinate)object2))) {
            StringBuilder stringBuilder = new StringBuilder("found non-noded intersection at ");
            stringBuilder.append(coordinate);
            stringBuilder.append("-");
            stringBuilder.append(object);
            stringBuilder.append(" and ");
            stringBuilder.append(coordinate2);
            stringBuilder.append("-");
            stringBuilder.append(object2);
            throw new RuntimeException(stringBuilder.toString());
        }
    }

    private void checkInteriorIntersections(SegmentString segmentString, SegmentString segmentString2) {
        Coordinate[] coordinateArray = segmentString.getCoordinates();
        Coordinate[] coordinateArray2 = segmentString2.getCoordinates();
        int n = 0;
        block0: while (n < coordinateArray.length - 1) {
            int n2 = 0;
            while (true) {
                if (n2 >= coordinateArray2.length - 1) {
                    ++n;
                    continue block0;
                }
                this.checkInteriorIntersections(segmentString, n, segmentString2, n2);
                ++n2;
            }
            break;
        }
        return;
    }

    private boolean hasInteriorIntersection(LineIntersector lineIntersector, Coordinate coordinate, Coordinate coordinate2) {
        int n = 0;
        while (n < lineIntersector.getIntersectionNum()) {
            Coordinate coordinate3 = lineIntersector.getIntersection(n);
            if (!coordinate3.equals(coordinate) && !coordinate3.equals(coordinate2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void checkValid() {
        this.checkEndPtVertexIntersections();
        this.checkInteriorIntersections();
        this.checkCollapses();
    }
}

