/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.Noder;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.util.CollectionUtil;
import java.util.Collection;

public class ScaledNoder
implements Noder {
    private boolean isScaled = false;
    private Noder noder;
    private double offsetX;
    private double offsetY;
    private double scaleFactor;

    public ScaledNoder(Noder noder, double d) {
        this(noder, d, 0.0, 0.0);
    }

    public ScaledNoder(Noder noder, double d, double d2, double d3) {
        this.noder = noder;
        this.scaleFactor = d;
        this.isScaled = this.isIntegerPrecision() ^ true;
    }

    private void rescale(Collection collection) {
        CollectionUtil.apply(collection, new CollectionUtil.Function(){

            @Override
            public Object execute(Object object) {
                object = (SegmentString)object;
                ScaledNoder.this.rescale(object.getCoordinates());
                return null;
            }
        });
    }

    private void rescale(Coordinate[] coordinateArray) {
        if (coordinateArray.length == 2) {
            new Coordinate(coordinateArray[0]);
            new Coordinate(coordinateArray[1]);
        }
        int n = 0;
        while (true) {
            if (n >= coordinateArray.length) {
                if (coordinateArray.length == 2 && coordinateArray[0].equals2D(coordinateArray[1])) {
                    System.out.println(coordinateArray);
                }
                return;
            }
            coordinateArray[n].x = coordinateArray[n].x / this.scaleFactor + this.offsetX;
            coordinateArray[n].y = coordinateArray[n].y / this.scaleFactor + this.offsetY;
            ++n;
        }
    }

    private Collection scale(Collection collection) {
        return CollectionUtil.transform(collection, new CollectionUtil.Function(){

            @Override
            public Object execute(Object object) {
                object = (SegmentString)object;
                return new NodedSegmentString(ScaledNoder.this.scale(object.getCoordinates()), object.getData());
            }
        });
    }

    private Coordinate[] scale(Coordinate[] coordinateArray) {
        Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length];
        int n = 0;
        while (n < coordinateArray.length) {
            coordinateArray2[n] = new Coordinate(Math.round((coordinateArray[n].x - this.offsetX) * this.scaleFactor), Math.round((coordinateArray[n].y - this.offsetY) * this.scaleFactor), coordinateArray[n].z);
            ++n;
        }
        return CoordinateArrays.removeRepeatedPoints(coordinateArray2);
    }

    @Override
    public void computeNodes(Collection collection) {
        Collection collection2 = collection;
        if (this.isScaled) {
            collection2 = this.scale(collection);
        }
        this.noder.computeNodes(collection2);
    }

    @Override
    public Collection getNodedSubstrings() {
        Collection collection = this.noder.getNodedSubstrings();
        if (this.isScaled) {
            this.rescale(collection);
        }
        return collection;
    }

    public boolean isIntegerPrecision() {
        return this.scaleFactor == 1.0;
    }
}

