/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;

public class SegmentIntersectionDetector
implements SegmentIntersector {
    private boolean findAllTypes = false;
    private boolean findProper = false;
    private boolean hasIntersection = false;
    private boolean hasNonProperIntersection = false;
    private boolean hasProperIntersection = false;
    private Coordinate intPt = null;
    private Coordinate[] intSegments = null;
    private LineIntersector li;

    public SegmentIntersectionDetector() {
        this(new RobustLineIntersector());
    }

    public SegmentIntersectionDetector(LineIntersector lineIntersector) {
        this.li = lineIntersector;
    }

    public Coordinate getIntersection() {
        return this.intPt;
    }

    public Coordinate[] getIntersectionSegments() {
        return this.intSegments;
    }

    public boolean hasIntersection() {
        return this.hasIntersection;
    }

    public boolean hasNonProperIntersection() {
        return this.hasNonProperIntersection;
    }

    public boolean hasProperIntersection() {
        return this.hasProperIntersection;
    }

    @Override
    public boolean isDone() {
        if (this.findAllTypes) {
            return this.hasProperIntersection && this.hasNonProperIntersection;
        }
        if (this.findProper) {
            return this.hasProperIntersection;
        }
        return this.hasIntersection;
    }

    @Override
    public void processIntersections(SegmentString object, int n, SegmentString coordinateArray, int n2) {
        if (object == coordinateArray && n == n2) {
            return;
        }
        Coordinate coordinate = object.getCoordinates()[n];
        object = object.getCoordinates()[n + 1];
        Coordinate coordinate2 = coordinateArray.getCoordinates()[n2];
        Coordinate coordinate3 = coordinateArray.getCoordinates()[n2 + 1];
        this.li.computeIntersection(coordinate, (Coordinate)object, coordinate2, coordinate3);
        if (this.li.hasIntersection()) {
            this.hasIntersection = true;
            boolean bl = this.li.isProper();
            if (bl) {
                this.hasProperIntersection = true;
            }
            if (!bl) {
                this.hasNonProperIntersection = true;
            }
            n = this.findProper && !bl ? 0 : 1;
            if (this.intPt == null || n != 0) {
                this.intPt = this.li.getIntersection(0);
                coordinateArray = new Coordinate[4];
                this.intSegments = coordinateArray;
                coordinateArray[0] = coordinate;
                coordinateArray[1] = object;
                coordinateArray[2] = coordinate2;
                coordinateArray[3] = coordinate3;
            }
        }
    }

    public void setFindAllIntersectionTypes(boolean bl) {
        this.findAllTypes = bl;
    }

    public void setFindProper(boolean bl) {
        this.findProper = bl;
    }
}

