/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.SegmentPointComparator;
import java.io.PrintStream;

public class SegmentNode
implements Comparable {
    public final Coordinate coord;
    private final boolean isInterior;
    private final NodedSegmentString segString;
    public final int segmentIndex;
    private final int segmentOctant;

    public SegmentNode(NodedSegmentString nodedSegmentString, Coordinate coordinate, int n, int n2) {
        this.segString = nodedSegmentString;
        this.coord = new Coordinate(coordinate);
        this.segmentIndex = n;
        this.segmentOctant = n2;
        this.isInterior = coordinate.equals2D(nodedSegmentString.getCoordinate(n)) ^ true;
    }

    public int compareTo(Object object) {
        object = (SegmentNode)object;
        int n = this.segmentIndex;
        int n2 = ((SegmentNode)object).segmentIndex;
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        if (this.coord.equals2D(((SegmentNode)object).coord)) {
            return 0;
        }
        return SegmentPointComparator.compare(this.segmentOctant, this.coord, ((SegmentNode)object).coord);
    }

    public Coordinate getCoordinate() {
        return this.coord;
    }

    public boolean isEndPoint(int n) {
        int n2 = this.segmentIndex;
        if (n2 == 0 && !this.isInterior) {
            return true;
        }
        return n2 == n;
    }

    public boolean isInterior() {
        return this.isInterior;
    }

    public void print(PrintStream printStream) {
        printStream.print(this.coord);
        StringBuilder stringBuilder = new StringBuilder(" seg # = ");
        stringBuilder.append(this.segmentIndex);
        printStream.print(stringBuilder.toString());
    }
}

