/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.noding.InteriorIntersectionFinderAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.Noder;
import com.vividsolutions.jts.noding.NodingValidator;
import com.vividsolutions.jts.noding.SinglePassNoder;
import com.vividsolutions.jts.noding.snapround.HotPixel;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SimpleSnapRounder
implements Noder {
    private LineIntersector li;
    private Collection nodedSegStrings;
    private final PrecisionModel pm;
    private final double scaleFactor;

    public SimpleSnapRounder(PrecisionModel precisionModel) {
        this.pm = precisionModel;
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        this.li = robustLineIntersector;
        robustLineIntersector.setPrecisionModel(precisionModel);
        this.scaleFactor = precisionModel.getScale();
    }

    private void checkCorrectness(Collection object) {
        object = new NodingValidator(NodedSegmentString.getNodedSubstrings((Collection)object));
        try {
            ((NodingValidator)object).checkValid();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void computeSnaps(NodedSegmentString nodedSegmentString, Collection object) {
        object = object.iterator();
        block0: while (object.hasNext()) {
            HotPixel hotPixel = new HotPixel((Coordinate)object.next(), this.scaleFactor, this.li);
            int n = 0;
            while (true) {
                if (n >= nodedSegmentString.size() - 1) continue block0;
                hotPixel.addSnappedNode(nodedSegmentString, n);
                ++n;
            }
            break;
        }
        return;
    }

    private void computeSnaps(Collection object, Collection collection) {
        object = object.iterator();
        while (object.hasNext()) {
            this.computeSnaps((NodedSegmentString)object.next(), collection);
        }
        return;
    }

    private void computeVertexSnaps(NodedSegmentString nodedSegmentString, NodedSegmentString nodedSegmentString2) {
        Coordinate[] coordinateArray = nodedSegmentString.getCoordinates();
        Coordinate[] coordinateArray2 = nodedSegmentString2.getCoordinates();
        int n = 0;
        block0: while (n < coordinateArray.length - 1) {
            HotPixel hotPixel = new HotPixel(coordinateArray[n], this.scaleFactor, this.li);
            int n2 = 0;
            while (true) {
                if (n2 >= coordinateArray2.length - 1) {
                    ++n;
                    continue block0;
                }
                if ((nodedSegmentString != nodedSegmentString2 || n != n2) && hotPixel.addSnappedNode(nodedSegmentString2, n2)) {
                    nodedSegmentString.addIntersection(coordinateArray[n], n);
                }
                ++n2;
            }
            break;
        }
        return;
    }

    private List findInteriorIntersections(Collection collection, LineIntersector object) {
        InteriorIntersectionFinderAdder interiorIntersectionFinderAdder = new InteriorIntersectionFinderAdder((LineIntersector)object);
        object = new MCIndexNoder();
        ((SinglePassNoder)object).setSegmentIntersector(interiorIntersectionFinderAdder);
        ((SinglePassNoder)object).computeNodes(collection);
        return interiorIntersectionFinderAdder.getInteriorIntersections();
    }

    private void snapRound(Collection collection, LineIntersector lineIntersector) {
        this.computeSnaps(collection, (Collection)this.findInteriorIntersections(collection, lineIntersector));
        this.computeVertexSnaps(collection);
    }

    @Override
    public void computeNodes(Collection collection) {
        this.nodedSegStrings = collection;
        this.snapRound(collection, this.li);
    }

    public void computeVertexSnaps(Collection collection) {
        Iterator iterator2 = collection.iterator();
        block0: while (iterator2.hasNext()) {
            NodedSegmentString nodedSegmentString = (NodedSegmentString)iterator2.next();
            Iterator iterator3 = collection.iterator();
            while (true) {
                if (!iterator3.hasNext()) continue block0;
                this.computeVertexSnaps(nodedSegmentString, (NodedSegmentString)iterator3.next());
            }
            break;
        }
        return;
    }

    @Override
    public Collection getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings(this.nodedSegStrings);
    }
}

