/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geomgraph.GeometryGraph;

public class GeometryGraphOperation {
    protected GeometryGraph[] arg;
    protected final LineIntersector li = new RobustLineIntersector();
    protected PrecisionModel resultPrecisionModel;

    public GeometryGraphOperation(Geometry geometry) {
        this.setComputationPrecision(geometry.getPrecisionModel());
        GeometryGraph[] geometryGraphArray = new GeometryGraph[1];
        this.arg = geometryGraphArray;
        geometryGraphArray[0] = new GeometryGraph(0, geometry);
    }

    public GeometryGraphOperation(Geometry geometry, Geometry geometry2) {
        this(geometry, geometry2, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE);
    }

    public GeometryGraphOperation(Geometry geometry, Geometry geometry2, BoundaryNodeRule boundaryNodeRule) {
        if (geometry.getPrecisionModel().compareTo(geometry2.getPrecisionModel()) >= 0) {
            this.setComputationPrecision(geometry.getPrecisionModel());
        } else {
            this.setComputationPrecision(geometry2.getPrecisionModel());
        }
        GeometryGraph[] geometryGraphArray = new GeometryGraph[2];
        this.arg = geometryGraphArray;
        geometryGraphArray[0] = new GeometryGraph(0, geometry, boundaryNodeRule);
        this.arg[1] = new GeometryGraph(1, geometry2, boundaryNodeRule);
    }

    public Geometry getArgGeometry(int n) {
        return this.arg[n].getGeometry();
    }

    protected void setComputationPrecision(PrecisionModel precisionModel) {
        this.resultPrecisionModel = precisionModel;
        this.li.setPrecisionModel(precisionModel);
    }
}

