/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class IsSimpleOp {
    private Geometry inputGeom;
    private boolean isClosedEndpointsInInterior = true;
    private Coordinate nonSimpleLocation = null;

    public IsSimpleOp() {
    }

    public IsSimpleOp(Geometry geometry) {
        this.inputGeom = geometry;
    }

    public IsSimpleOp(Geometry geometry, BoundaryNodeRule boundaryNodeRule) {
        this.inputGeom = geometry;
        this.isClosedEndpointsInInterior = boundaryNodeRule.isInBoundary(2) ^ true;
    }

    private void addEndpoint(Map map, Coordinate coordinate, boolean bl) {
        EndpointInfo endpointInfo;
        EndpointInfo endpointInfo2 = endpointInfo = (EndpointInfo)map.get(coordinate);
        if (endpointInfo == null) {
            endpointInfo2 = new EndpointInfo(coordinate);
            map.put(coordinate, endpointInfo2);
        }
        endpointInfo2.addEndpoint(bl);
    }

    private boolean computeSimple(Geometry geometry) {
        this.nonSimpleLocation = null;
        if (geometry.isEmpty()) {
            return true;
        }
        if (geometry instanceof LineString) {
            return this.isSimpleLinearGeometry(geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.isSimpleLinearGeometry(geometry);
        }
        if (geometry instanceof MultiPoint) {
            return this.isSimpleMultiPoint((MultiPoint)geometry);
        }
        if (geometry instanceof Polygonal) {
            return this.isSimplePolygonal(geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.isSimpleGeometryCollection(geometry);
        }
        return true;
    }

    private boolean hasClosedEndpointIntersection(GeometryGraph iterator2) {
        Object object = new TreeMap();
        iterator2 = ((PlanarGraph)((Object)iterator2)).getEdgeIterator();
        while (true) {
            if (!iterator2.hasNext()) {
                iterator2 = object.values().iterator();
                do {
                    if (!iterator2.hasNext()) {
                        return false;
                    }
                    object = (EndpointInfo)iterator2.next();
                } while (!((EndpointInfo)object).isClosed || ((EndpointInfo)object).degree == 2);
                this.nonSimpleLocation = ((EndpointInfo)object).getCoordinate();
                return true;
            }
            Edge edge = (Edge)iterator2.next();
            edge.getMaximumSegmentIndex();
            boolean bl = edge.isClosed();
            this.addEndpoint((Map)object, edge.getCoordinate(0), bl);
            this.addEndpoint((Map)object, edge.getCoordinate(edge.getNumPoints() - 1), bl);
        }
    }

    private boolean hasNonEndpointIntersection(GeometryGraph object) {
        EdgeIntersection edgeIntersection;
        object = ((PlanarGraph)object).getEdgeIterator();
        block0: while (true) {
            if (!object.hasNext()) {
                return false;
            }
            Object object2 = (Edge)object.next();
            int n = ((Edge)object2).getMaximumSegmentIndex();
            object2 = ((Edge)object2).getEdgeIntersectionList().iterator();
            do {
                if (!object2.hasNext()) continue block0;
            } while ((edgeIntersection = (EdgeIntersection)object2.next()).isEndPoint(n));
            break;
        }
        this.nonSimpleLocation = edgeIntersection.getCoordinate();
        return true;
    }

    private boolean isSimpleGeometryCollection(Geometry geometry) {
        int n = 0;
        while (n < geometry.getNumGeometries()) {
            if (!this.computeSimple(geometry.getGeometryN(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isSimpleLinearGeometry(Geometry object) {
        if (((Geometry)object).isEmpty()) {
            return true;
        }
        SegmentIntersector segmentIntersector = ((GeometryGraph)(object = new GeometryGraph(0, (Geometry)object))).computeSelfNodes(new RobustLineIntersector(), true);
        if (!segmentIntersector.hasIntersection()) {
            return true;
        }
        if (segmentIntersector.hasProperIntersection()) {
            this.nonSimpleLocation = segmentIntersector.getProperIntersectionPoint();
            return false;
        }
        if (this.hasNonEndpointIntersection((GeometryGraph)object)) {
            return false;
        }
        return !this.isClosedEndpointsInInterior || !this.hasClosedEndpointIntersection((GeometryGraph)object);
    }

    private boolean isSimpleMultiPoint(MultiPoint multiPoint) {
        if (multiPoint.isEmpty()) {
            return true;
        }
        TreeSet<Coordinate> treeSet = new TreeSet<Coordinate>();
        int n = 0;
        while (n < multiPoint.getNumGeometries()) {
            Coordinate coordinate = ((Point)multiPoint.getGeometryN(n)).getCoordinate();
            if (treeSet.contains(coordinate)) {
                this.nonSimpleLocation = coordinate;
                return false;
            }
            treeSet.add(coordinate);
            ++n;
        }
        return true;
    }

    private boolean isSimplePolygonal(Geometry object) {
        object = LinearComponentExtracter.getLines((Geometry)object).iterator();
        do {
            if (object.hasNext()) continue;
            return true;
        } while (this.isSimpleLinearGeometry((LinearRing)object.next()));
        return false;
    }

    public Coordinate getNonSimpleLocation() {
        return this.nonSimpleLocation;
    }

    public boolean isSimple() {
        this.nonSimpleLocation = null;
        return this.computeSimple(this.inputGeom);
    }

    public boolean isSimple(LineString lineString) {
        return this.isSimpleLinearGeometry(lineString);
    }

    public boolean isSimple(MultiLineString multiLineString) {
        return this.isSimpleLinearGeometry(multiLineString);
    }

    public boolean isSimple(MultiPoint multiPoint) {
        return this.isSimpleMultiPoint(multiPoint);
    }

    private static class EndpointInfo {
        int degree;
        boolean isClosed;
        Coordinate pt;

        public EndpointInfo(Coordinate coordinate) {
            this.pt = coordinate;
            this.isClosed = false;
            this.degree = 0;
        }

        public void addEndpoint(boolean bl) {
            ++this.degree;
            this.isClosed = bl | this.isClosed;
        }

        public Coordinate getCoordinate() {
            return this.pt;
        }
    }
}

