/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeList;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.noding.IntersectionAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.Noder;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.noding.SinglePassNoder;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.buffer.BufferSubgraph;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import com.vividsolutions.jts.operation.buffer.OffsetCurveSetBuilder;
import com.vividsolutions.jts.operation.buffer.SubgraphDepthLocater;
import com.vividsolutions.jts.operation.overlay.OverlayNodeFactory;
import com.vividsolutions.jts.operation.overlay.PolygonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class BufferBuilder {
    private BufferParameters bufParams;
    private EdgeList edgeList = new EdgeList();
    private GeometryFactory geomFact;
    private PlanarGraph graph;
    private Noder workingNoder;
    private PrecisionModel workingPrecisionModel;

    public BufferBuilder(BufferParameters bufferParameters) {
        this.bufParams = bufferParameters;
    }

    private void buildSubgraphs(List object, PolygonBuilder polygonBuilder) {
        ArrayList<BufferSubgraph> arrayList = new ArrayList<BufferSubgraph>();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            BufferSubgraph bufferSubgraph = (BufferSubgraph)iterator2.next();
            object = bufferSubgraph.getRightmostCoordinate();
            bufferSubgraph.computeDepth(new SubgraphDepthLocater(arrayList).getDepth((Coordinate)object));
            bufferSubgraph.findResultEdges();
            arrayList.add(bufferSubgraph);
            polygonBuilder.add(bufferSubgraph.getDirectedEdges(), bufferSubgraph.getNodes());
        }
        return;
    }

    private void computeNodedEdges(List object, PrecisionModel iterator2) {
        iterator2 = this.getNoder((PrecisionModel)((Object)iterator2));
        iterator2.computeNodes((Collection)object);
        iterator2 = iterator2.getNodedSubstrings().iterator();
        while (iterator2.hasNext()) {
            object = (SegmentString)iterator2.next();
            Object object2 = object.getCoordinates();
            if (((Coordinate[])object2).length == 2 && object2[0].equals2D(object2[1])) continue;
            object2 = (Label)object.getData();
            this.insertUniqueEdge(new Edge(object.getCoordinates(), new Label((Label)object2)));
        }
        return;
    }

    private static Geometry convertSegStrings(Iterator iterator2) {
        GeometryFactory geometryFactory = new GeometryFactory();
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        while (iterator2.hasNext()) {
            arrayList.add(geometryFactory.createLineString(((SegmentString)iterator2.next()).getCoordinates()));
        }
        return geometryFactory.buildGeometry(arrayList);
    }

    private Geometry createEmptyResultGeometry() {
        return this.geomFact.createPolygon(null, null);
    }

    private List createSubgraphs(PlanarGraph object) {
        ArrayList<BufferSubgraph> arrayList = new ArrayList<BufferSubgraph>();
        Iterator iterator2 = ((PlanarGraph)object).getNodes().iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                Collections.sort(arrayList, Collections.reverseOrder());
                return arrayList;
            }
            object = (Node)iterator2.next();
            if (((GraphComponent)object).isVisited()) continue;
            BufferSubgraph bufferSubgraph = new BufferSubgraph();
            bufferSubgraph.create((Node)object);
            arrayList.add(bufferSubgraph);
        }
    }

    private static int depthDelta(Label label) {
        int n = label.getLocation(0, 1);
        int n2 = label.getLocation(0, 2);
        if (n == 0 && n2 == 2) {
            return 1;
        }
        if (n == 2 && n2 == 0) {
            return -1;
        }
        return 0;
    }

    private Noder getNoder(PrecisionModel precisionModel) {
        Noder noder = this.workingNoder;
        if (noder != null) {
            return noder;
        }
        noder = new MCIndexNoder();
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        robustLineIntersector.setPrecisionModel(precisionModel);
        ((SinglePassNoder)noder).setSegmentIntersector(new IntersectionAdder(robustLineIntersector));
        return noder;
    }

    public Geometry buffer(Geometry object, double d) {
        PrecisionModel precisionModel = this.workingPrecisionModel;
        Object object2 = precisionModel;
        if (precisionModel == null) {
            object2 = ((Geometry)object).getPrecisionModel();
        }
        this.geomFact = ((Geometry)object).getFactory();
        if ((object = new OffsetCurveSetBuilder((Geometry)object, d, new OffsetCurveBuilder((PrecisionModel)object2, this.bufParams)).getCurves()).size() <= 0) {
            return this.createEmptyResultGeometry();
        }
        this.computeNodedEdges((List)object, (PrecisionModel)object2);
        this.graph = object = new PlanarGraph(new OverlayNodeFactory());
        ((PlanarGraph)object).addEdges(this.edgeList.getEdges());
        object2 = this.createSubgraphs(this.graph);
        object = new PolygonBuilder(this.geomFact);
        this.buildSubgraphs((List)object2, (PolygonBuilder)object);
        object = ((PolygonBuilder)object).getPolygons();
        if (object.size() <= 0) {
            return this.createEmptyResultGeometry();
        }
        return this.geomFact.buildGeometry((Collection)object);
    }

    protected void insertUniqueEdge(Edge edge) {
        Edge edge2 = this.edgeList.findEqualEdge(edge);
        if (edge2 != null) {
            Label label = edge2.getLabel();
            Label label2 = edge.getLabel();
            if (!edge2.isPointwiseEqual(edge)) {
                label2 = new Label(edge.getLabel());
                label2.flip();
            }
            label.merge(label2);
            int n = BufferBuilder.depthDelta(label2);
            edge2.setDepthDelta(edge2.getDepthDelta() + n);
        } else {
            this.edgeList.add(edge);
            edge.setDepthDelta(BufferBuilder.depthDelta(edge.getLabel()));
        }
    }

    public void setNoder(Noder noder) {
        this.workingNoder = noder;
    }

    public void setWorkingPrecisionModel(PrecisionModel precisionModel) {
        this.workingPrecisionModel = precisionModel;
    }
}

