/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.buffer.RightmostEdgeFinder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

class BufferSubgraph
implements Comparable {
    private List dirEdgeList = new ArrayList();
    private Envelope env = null;
    private RightmostEdgeFinder finder;
    private List nodes = new ArrayList();
    private Coordinate rightMostCoord = null;

    public BufferSubgraph() {
        this.finder = new RightmostEdgeFinder();
    }

    private void add(Node object, Stack stack) {
        ((GraphComponent)object).setVisited(true);
        this.nodes.add(object);
        object = ((DirectedEdgeStar)((Node)object).getEdges()).iterator();
        while (object.hasNext()) {
            Object object2 = (DirectedEdge)object.next();
            this.dirEdgeList.add(object2);
            if (((GraphComponent)(object2 = ((DirectedEdge)object2).getSym().getNode())).isVisited()) continue;
            stack.push(object2);
        }
        return;
    }

    private void addReachable(Node node) {
        Stack<Node> stack = new Stack<Node>();
        stack.add(node);
        while (!stack.empty()) {
            this.add((Node)stack.pop(), stack);
        }
        return;
    }

    private void clearVisitedEdges() {
        Iterator iterator2 = this.dirEdgeList.iterator();
        while (iterator2.hasNext()) {
            ((DirectedEdge)iterator2.next()).setVisited(false);
        }
        return;
    }

    private void computeDepths(DirectedEdge object) {
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object object2 = ((EdgeEnd)object).getNode();
        linkedList.addLast(object2);
        hashSet.add(object2);
        ((DirectedEdge)object).setVisited(true);
        block0: while (!linkedList.isEmpty()) {
            object = (Node)linkedList.removeFirst();
            hashSet.add(object);
            this.computeNodeDepth((Node)object);
            object = ((DirectedEdgeStar)((Node)object).getEdges()).iterator();
            while (true) {
                if (!object.hasNext()) continue block0;
                object2 = ((DirectedEdge)object.next()).getSym();
                if (((DirectedEdge)object2).isVisited() || hashSet.contains(object2 = ((EdgeEnd)object2).getNode())) continue;
                linkedList.addLast(object2);
                hashSet.add(object2);
            }
            break;
        }
        return;
    }

    private void computeNodeDepth(Node object) {
        Comparable comparable;
        Iterator iterator2 = ((DirectedEdgeStar)((Node)object).getEdges()).iterator();
        do {
            if (iterator2.hasNext()) continue;
            comparable = null;
            break;
        } while (!((DirectedEdge)(comparable = (DirectedEdge)iterator2.next())).isVisited() && !((DirectedEdge)comparable).getSym().isVisited());
        if (comparable != null) {
            ((DirectedEdgeStar)((Node)object).getEdges()).computeDepths((DirectedEdge)comparable);
            object = ((DirectedEdgeStar)((Node)object).getEdges()).iterator();
            while (true) {
                if (!object.hasNext()) {
                    return;
                }
                comparable = (DirectedEdge)object.next();
                ((DirectedEdge)comparable).setVisited(true);
                this.copySymDepths((DirectedEdge)comparable);
            }
        }
        comparable = new StringBuilder("unable to find edge to compute depths at ");
        ((StringBuilder)comparable).append(((Node)object).getCoordinate());
        throw new TopologyException(((StringBuilder)comparable).toString());
    }

    private void copySymDepths(DirectedEdge directedEdge) {
        DirectedEdge directedEdge2 = directedEdge.getSym();
        directedEdge2.setDepth(1, directedEdge.getDepth(2));
        directedEdge2.setDepth(2, directedEdge.getDepth(1));
    }

    public int compareTo(Object object) {
        object = (BufferSubgraph)object;
        if (this.rightMostCoord.x < ((BufferSubgraph)object).rightMostCoord.x) {
            return -1;
        }
        if (this.rightMostCoord.x > ((BufferSubgraph)object).rightMostCoord.x) {
            return 1;
        }
        return 0;
    }

    public void computeDepth(int n) {
        this.clearVisitedEdges();
        DirectedEdge directedEdge = this.finder.getEdge();
        directedEdge.getNode();
        directedEdge.getLabel();
        directedEdge.setEdgeDepths(2, n);
        this.copySymDepths(directedEdge);
        this.computeDepths(directedEdge);
    }

    public void create(Node node) {
        this.addReachable(node);
        this.finder.findEdge(this.dirEdgeList);
        this.rightMostCoord = this.finder.getCoordinate();
    }

    public void findResultEdges() {
        Iterator iterator2 = this.dirEdgeList.iterator();
        while (iterator2.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator2.next();
            if (directedEdge.getDepth(2) < 1 || directedEdge.getDepth(1) > 0 || directedEdge.isInteriorAreaEdge()) continue;
            directedEdge.setInResult(true);
        }
        return;
    }

    public List getDirectedEdges() {
        return this.dirEdgeList;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            Envelope envelope = new Envelope();
            Iterator iterator2 = this.dirEdgeList.iterator();
            block0: while (true) {
                if (!iterator2.hasNext()) {
                    this.env = envelope;
                    break;
                }
                Coordinate[] coordinateArray = ((DirectedEdge)iterator2.next()).getEdge().getCoordinates();
                int n = 0;
                while (true) {
                    if (n >= coordinateArray.length - 1) continue block0;
                    envelope.expandToInclude(coordinateArray[n]);
                    ++n;
                }
                break;
            }
        }
        return this.env;
    }

    public List getNodes() {
        return this.nodes;
    }

    public Coordinate getRightmostCoordinate() {
        return this.rightMostCoord;
    }
}

