/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.buffer.BufferInputLineSimplifier;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.buffer.OffsetSegmentGenerator;

public class OffsetCurveBuilder {
    private BufferParameters bufParams;
    private double distance = 0.0;
    private PrecisionModel precisionModel;

    public OffsetCurveBuilder(PrecisionModel precisionModel, BufferParameters bufferParameters) {
        this.precisionModel = precisionModel;
        this.bufParams = bufferParameters;
    }

    private void computeLineBufferCurve(Coordinate[] coordinateArray, OffsetSegmentGenerator offsetSegmentGenerator) {
        double d = this.simplifyTolerance(this.distance);
        Coordinate[] coordinateArray2 = BufferInputLineSimplifier.simplify(coordinateArray, d);
        int n = coordinateArray2.length - 1;
        offsetSegmentGenerator.initSideSegments(coordinateArray2[0], coordinateArray2[1], 1);
        int n2 = 2;
        while (true) {
            if (n2 > n) {
                offsetSegmentGenerator.addLastSegment();
                offsetSegmentGenerator.addLineEndCap(coordinateArray2[n - 1], coordinateArray2[n]);
                coordinateArray = BufferInputLineSimplifier.simplify(coordinateArray, -d);
                n2 = coordinateArray.length - 1;
                offsetSegmentGenerator.initSideSegments(coordinateArray[n2], coordinateArray[n2 - 1], 1);
                n2 -= 2;
                while (true) {
                    if (n2 < 0) {
                        offsetSegmentGenerator.addLastSegment();
                        offsetSegmentGenerator.addLineEndCap(coordinateArray[1], coordinateArray[0]);
                        offsetSegmentGenerator.closeRing();
                        return;
                    }
                    offsetSegmentGenerator.addNextSegment(coordinateArray[n2], true);
                    --n2;
                }
            }
            offsetSegmentGenerator.addNextSegment(coordinateArray2[n2], true);
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void computeOffsetCurve(Coordinate[] coordinateArray, boolean bl, OffsetSegmentGenerator offsetSegmentGenerator) {
        int n;
        double d = this.simplifyTolerance(this.distance);
        if (bl) {
            coordinateArray = BufferInputLineSimplifier.simplify(coordinateArray, -d);
            n = coordinateArray.length - 1;
            offsetSegmentGenerator.initSideSegments(coordinateArray[n], coordinateArray[n - 1], 1);
            offsetSegmentGenerator.addFirstSegment();
            n -= 2;
            while (n >= 0) {
                offsetSegmentGenerator.addNextSegment(coordinateArray[n], true);
                --n;
            }
        } else {
            coordinateArray = BufferInputLineSimplifier.simplify(coordinateArray, d);
            int n2 = coordinateArray.length;
            offsetSegmentGenerator.initSideSegments(coordinateArray[0], coordinateArray[1], 1);
            offsetSegmentGenerator.addFirstSegment();
            for (n = 2; n <= n2 - 1; ++n) {
                offsetSegmentGenerator.addNextSegment(coordinateArray[n], true);
            }
        }
        offsetSegmentGenerator.addLastSegment();
    }

    private void computePointCurve(Coordinate coordinate, OffsetSegmentGenerator offsetSegmentGenerator) {
        int n = this.bufParams.getEndCapStyle();
        if (n != 1) {
            if (n == 3) {
                offsetSegmentGenerator.createSquare(coordinate);
            }
        } else {
            offsetSegmentGenerator.createCircle(coordinate);
        }
    }

    private void computeRingBufferCurve(Coordinate[] coordinateArray, int n, OffsetSegmentGenerator offsetSegmentGenerator) {
        double d;
        double d2 = d = this.simplifyTolerance(this.distance);
        if (n == 2) {
            d2 = -d;
        }
        coordinateArray = BufferInputLineSimplifier.simplify(coordinateArray, d2);
        int n2 = coordinateArray.length - 1;
        offsetSegmentGenerator.initSideSegments(coordinateArray[n2 - 1], coordinateArray[0], n);
        n = 1;
        while (true) {
            if (n > n2) {
                offsetSegmentGenerator.closeRing();
                return;
            }
            boolean bl = n != 1;
            offsetSegmentGenerator.addNextSegment(coordinateArray[n], bl);
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void computeSingleSidedBufferCurve(Coordinate[] coordinateArray, boolean bl, OffsetSegmentGenerator offsetSegmentGenerator) {
        int n;
        double d = this.simplifyTolerance(this.distance);
        if (bl) {
            offsetSegmentGenerator.addSegments(coordinateArray, true);
            coordinateArray = BufferInputLineSimplifier.simplify(coordinateArray, -d);
            n = coordinateArray.length - 1;
            offsetSegmentGenerator.initSideSegments(coordinateArray[n], coordinateArray[n - 1], 1);
            offsetSegmentGenerator.addFirstSegment();
            n -= 2;
            while (n >= 0) {
                offsetSegmentGenerator.addNextSegment(coordinateArray[n], true);
                --n;
            }
        } else {
            offsetSegmentGenerator.addSegments(coordinateArray, false);
            coordinateArray = BufferInputLineSimplifier.simplify(coordinateArray, d);
            int n2 = coordinateArray.length;
            offsetSegmentGenerator.initSideSegments(coordinateArray[0], coordinateArray[1], 1);
            offsetSegmentGenerator.addFirstSegment();
            for (n = 2; n <= n2 - 1; ++n) {
                offsetSegmentGenerator.addNextSegment(coordinateArray[n], true);
            }
        }
        offsetSegmentGenerator.addLastSegment();
        offsetSegmentGenerator.closeRing();
    }

    private static Coordinate[] copyCoordinates(Coordinate[] coordinateArray) {
        int n = coordinateArray.length;
        Coordinate[] coordinateArray2 = new Coordinate[n];
        int n2 = 0;
        while (n2 < n) {
            coordinateArray2[n2] = new Coordinate(coordinateArray[n2]);
            ++n2;
        }
        return coordinateArray2;
    }

    private OffsetSegmentGenerator getSegGen(double d) {
        return new OffsetSegmentGenerator(this.precisionModel, this.bufParams, d);
    }

    private double simplifyTolerance(double d) {
        return d * this.bufParams.getSimplifyFactor();
    }

    public BufferParameters getBufferParameters() {
        return this.bufParams;
    }

    public Coordinate[] getLineCurve(Coordinate[] coordinateArray, double d) {
        this.distance = d;
        double d2 = d - 0.0;
        double d3 = d2 == 0.0 ? 0 : (d2 < 0.0 ? -1 : 1);
        if (d3 < 0 && !this.bufParams.isSingleSided()) {
            return null;
        }
        if (d == 0.0) {
            return null;
        }
        OffsetSegmentGenerator offsetSegmentGenerator = this.getSegGen(Math.abs(d));
        int n = coordinateArray.length;
        boolean bl = false;
        if (n <= 1) {
            this.computePointCurve(coordinateArray[0], offsetSegmentGenerator);
        } else if (this.bufParams.isSingleSided()) {
            if (d3 < 0) {
                bl = true;
            }
            this.computeSingleSidedBufferCurve(coordinateArray, bl, offsetSegmentGenerator);
        } else {
            this.computeLineBufferCurve(coordinateArray, offsetSegmentGenerator);
        }
        return offsetSegmentGenerator.getCoordinates();
    }

    public Coordinate[] getOffsetCurve(Coordinate[] coordinateArray, double d) {
        this.distance = d;
        if (d == 0.0) {
            return null;
        }
        boolean bl = d < 0.0;
        OffsetSegmentGenerator offsetSegmentGenerator = this.getSegGen(Math.abs(d));
        if (coordinateArray.length <= 1) {
            this.computePointCurve(coordinateArray[0], offsetSegmentGenerator);
        } else {
            this.computeOffsetCurve(coordinateArray, bl, offsetSegmentGenerator);
        }
        coordinateArray = offsetSegmentGenerator.getCoordinates();
        if (bl) {
            CoordinateArrays.reverse(coordinateArray);
        }
        return coordinateArray;
    }

    public Coordinate[] getRingCurve(Coordinate[] coordinateArray, int n, double d) {
        this.distance = d;
        if (coordinateArray.length <= 2) {
            return this.getLineCurve(coordinateArray, d);
        }
        if (d == 0.0) {
            return OffsetCurveBuilder.copyCoordinates(coordinateArray);
        }
        OffsetSegmentGenerator offsetSegmentGenerator = this.getSegGen(d);
        this.computeRingBufferCurve(coordinateArray, n, offsetSegmentGenerator);
        return offsetSegmentGenerator.getCoordinates();
    }
}

