/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Position;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import java.util.ArrayList;
import java.util.List;

public class OffsetCurveSetBuilder {
    private OffsetCurveBuilder curveBuilder;
    private List curveList = new ArrayList();
    private double distance;
    private Geometry inputGeom;

    public OffsetCurveSetBuilder(Geometry geometry, double d, OffsetCurveBuilder offsetCurveBuilder) {
        this.inputGeom = geometry;
        this.distance = d;
        this.curveBuilder = offsetCurveBuilder;
    }

    private void add(Geometry geometry) {
        block11: {
            block5: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block4: {
                                        if (geometry.isEmpty()) {
                                            return;
                                        }
                                        if (!(geometry instanceof Polygon)) break block4;
                                        this.addPolygon((Polygon)geometry);
                                        break block5;
                                    }
                                    if (!(geometry instanceof LineString)) break block6;
                                    this.addLineString((LineString)geometry);
                                    break block5;
                                }
                                if (!(geometry instanceof Point)) break block7;
                                this.addPoint((Point)geometry);
                                break block5;
                            }
                            if (!(geometry instanceof MultiPoint)) break block8;
                            this.addCollection((MultiPoint)geometry);
                            break block5;
                        }
                        if (!(geometry instanceof MultiLineString)) break block9;
                        this.addCollection((MultiLineString)geometry);
                        break block5;
                    }
                    if (!(geometry instanceof MultiPolygon)) break block10;
                    this.addCollection((MultiPolygon)geometry);
                    break block5;
                }
                if (!(geometry instanceof GeometryCollection)) break block11;
                this.addCollection((GeometryCollection)geometry);
            }
            return;
        }
        throw new UnsupportedOperationException(geometry.getClass().getName());
    }

    private void addCollection(GeometryCollection geometryCollection) {
        int n = 0;
        while (n < geometryCollection.getNumGeometries()) {
            this.add(geometryCollection.getGeometryN(n));
            ++n;
        }
        return;
    }

    private void addCurve(Coordinate[] object, int n, int n2) {
        if (object != null && ((Coordinate[])object).length >= 2) {
            object = new NodedSegmentString((Coordinate[])object, new Label(0, 1, n, n2));
            this.curveList.add(object);
        }
    }

    private void addLineString(LineString coordinateArray) {
        if (this.distance <= 0.0 && !this.curveBuilder.getBufferParameters().isSingleSided()) {
            return;
        }
        coordinateArray = CoordinateArrays.removeRepeatedPoints(coordinateArray.getCoordinates());
        this.addCurve(this.curveBuilder.getLineCurve(coordinateArray, this.distance), 2, 0);
    }

    private void addPoint(Point coordinateArray) {
        if (this.distance <= 0.0) {
            return;
        }
        coordinateArray = coordinateArray.getCoordinates();
        this.addCurve(this.curveBuilder.getLineCurve(coordinateArray, this.distance), 2, 0);
    }

    private void addPolygon(Polygon polygon) {
        int n;
        double d = this.distance;
        if (d < 0.0) {
            d = -d;
            n = 2;
        } else {
            n = 1;
        }
        Coordinate[] coordinateArray = (Coordinate[])polygon.getExteriorRing();
        Object object = CoordinateArrays.removeRepeatedPoints(coordinateArray.getCoordinates());
        double d2 = this.distance;
        if (d2 < 0.0 && this.isErodedCompletely((LinearRing)coordinateArray, d2)) {
            return;
        }
        if (this.distance <= 0.0 && ((Coordinate[])object).length < 3) {
            return;
        }
        this.addPolygonRing((Coordinate[])object, d, n, 2, 0);
        int n2 = 0;
        while (n2 < polygon.getNumInteriorRing()) {
            object = (LinearRing)polygon.getInteriorRingN(n2);
            coordinateArray = CoordinateArrays.removeRepeatedPoints(((LineString)object).getCoordinates());
            d2 = this.distance;
            if (!(d2 > 0.0) || !this.isErodedCompletely((LinearRing)object, -d2)) {
                this.addPolygonRing(coordinateArray, d, Position.opposite(n), 0, 2);
            }
            ++n2;
        }
        return;
    }

    private void addPolygonRing(Coordinate[] coordinateArray, double d, int n, int n2, int n3) {
        if (d == 0.0 && coordinateArray.length < 4) {
            return;
        }
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        if (coordinateArray.length >= 4) {
            n4 = n;
            n5 = n2;
            n6 = n3;
            if (CGAlgorithms.isCCW(coordinateArray)) {
                n4 = Position.opposite(n);
                n6 = n2;
                n5 = n3;
            }
        }
        this.addCurve(this.curveBuilder.getRingCurve(coordinateArray, n4, d), n5, n6);
    }

    private boolean isErodedCompletely(LinearRing comparable, double d) {
        Coordinate[] coordinateArray = ((LineString)comparable).getCoordinates();
        if (coordinateArray.length < 4) {
            return d < 0.0;
        }
        if (coordinateArray.length == 4) {
            return this.isTriangleErodedCompletely(coordinateArray, d);
        }
        comparable = ((Geometry)comparable).getEnvelopeInternal();
        double d2 = Math.min(((Envelope)comparable).getHeight(), ((Envelope)comparable).getWidth());
        return d < 0.0 && Math.abs(d) * 2.0 > d2;
    }

    private boolean isTriangleErodedCompletely(Coordinate[] object, double d) {
        return CGAlgorithms.distancePointLine(((Triangle)(object = new Triangle(object[0], object[1], object[2]))).inCentre(), ((Triangle)object).p0, ((Triangle)object).p1) < Math.abs(d);
    }

    public List getCurves() {
        this.add(this.inputGeom);
        return this.curveList;
    }
}

