/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;

class OffsetSegmentString {
    private static final Coordinate[] COORDINATE_ARRAY_TYPE = new Coordinate[0];
    private double minimimVertexDistance = 0.0;
    private PrecisionModel precisionModel = null;
    private ArrayList ptList = new ArrayList();

    private boolean isRedundant(Coordinate coordinate) {
        if (this.ptList.size() < 1) {
            return false;
        }
        ArrayList arrayList = this.ptList;
        return coordinate.distance((Coordinate)arrayList.get(arrayList.size() - 1)) < this.minimimVertexDistance;
    }

    public void addPt(Coordinate coordinate) {
        coordinate = new Coordinate(coordinate);
        this.precisionModel.makePrecise(coordinate);
        if (this.isRedundant(coordinate)) {
            return;
        }
        this.ptList.add(coordinate);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addPts(Coordinate[] coordinateArray, boolean bl) {
        if (bl) {
            int n = 0;
            while (true) {
                if (n >= coordinateArray.length) {
                    return;
                }
                this.addPt(coordinateArray[n]);
                ++n;
            }
        }
        int n = coordinateArray.length - 1;
        while (n >= 0) {
            this.addPt(coordinateArray[n]);
            --n;
        }
        return;
    }

    public void closeRing() {
        if (this.ptList.size() < 1) {
            return;
        }
        Coordinate coordinate = new Coordinate((Coordinate)this.ptList.get(0));
        Cloneable cloneable = this.ptList;
        cloneable = (Coordinate)cloneable.get(cloneable.size() - 1);
        if (this.ptList.size() >= 2) {
            Cloneable cloneable2 = this.ptList;
            cloneable2 = (Coordinate)cloneable2.get(cloneable2.size() - 2);
        }
        if (coordinate.equals(cloneable)) {
            return;
        }
        this.ptList.add(coordinate);
    }

    public Coordinate[] getCoordinates() {
        return this.ptList.toArray(COORDINATE_ARRAY_TYPE);
    }

    public void reverse() {
    }

    public void setMinimumVertexDistance(double d) {
        this.minimimVertexDistance = d;
    }

    public void setPrecisionModel(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
    }

    public String toString() {
        return new GeometryFactory().createLineString(this.getCoordinates()).toString();
    }
}

