/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.util.Assert;
import java.util.Iterator;
import java.util.List;

class RightmostEdgeFinder {
    private Coordinate minCoord = null;
    private DirectedEdge minDe = null;
    private int minIndex = -1;
    private DirectedEdge orientedDe = null;

    private void checkForRightmostCoordinate(DirectedEdge directedEdge) {
        Coordinate[] coordinateArray = directedEdge.getEdge().getCoordinates();
        int n = 0;
        while (n < coordinateArray.length - 1) {
            if (this.minCoord == null || coordinateArray[n].x > this.minCoord.x) {
                this.minDe = directedEdge;
                this.minIndex = n;
                this.minCoord = coordinateArray[n];
            }
            ++n;
        }
        return;
    }

    private void findRightmostEdgeAtNode() {
        DirectedEdge directedEdge;
        this.minDe = directedEdge = ((DirectedEdgeStar)this.minDe.getNode().getEdges()).getRightmostEdge();
        if (!directedEdge.isForward()) {
            this.minDe = directedEdge = this.minDe.getSym();
            this.minIndex = directedEdge.getEdge().getCoordinates().length - 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void findRightmostEdgeAtVertex() {
        int n;
        block5: {
            block4: {
                Coordinate[] coordinateArray = this.minDe.getEdge().getCoordinates();
                n = this.minIndex;
                int n2 = 0;
                boolean bl = n > 0 && n < coordinateArray.length;
                Assert.isTrue(bl, "rightmost point expected to be interior vertex of edge");
                n = this.minIndex;
                Coordinate coordinate = coordinateArray[n - 1];
                Coordinate coordinate2 = coordinateArray[n + 1];
                int n3 = CGAlgorithms.computeOrientation(this.minCoord, coordinate2, coordinate);
                if (coordinate.y < this.minCoord.y && coordinate2.y < this.minCoord.y && n3 == 1) break block4;
                n = n2;
                if (!(coordinate.y > this.minCoord.y)) break block5;
                n = n2;
                if (!(coordinate2.y > this.minCoord.y)) break block5;
                n = n2;
                if (n3 != -1) break block5;
            }
            n = 1;
        }
        if (n != 0) {
            --this.minIndex;
        }
    }

    private int getRightmostSide(DirectedEdge directedEdge, int n) {
        int n2;
        int n3 = n2 = this.getRightmostSideOfSegment(directedEdge, n);
        if (n2 < 0) {
            n3 = this.getRightmostSideOfSegment(directedEdge, n - 1);
        }
        if (n3 < 0) {
            this.minCoord = null;
            this.checkForRightmostCoordinate(directedEdge);
        }
        return n3;
    }

    private int getRightmostSideOfSegment(DirectedEdge coordinateArray, int n) {
        int n2;
        coordinateArray = coordinateArray.getEdge().getCoordinates();
        if (n >= 0 && (n2 = n + 1) < coordinateArray.length) {
            if (coordinateArray[n].y == coordinateArray[n2].y) {
                return -1;
            }
            n = coordinateArray[n].y < coordinateArray[n2].y ? 2 : 1;
            return n;
        }
        return -1;
    }

    public void findEdge(List object) {
        Iterator iterator2 = object.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                boolean bl = this.minIndex != 0 || this.minCoord.equals(this.minDe.getCoordinate());
                Assert.isTrue(bl, "inconsistency in rightmost processing");
                if (this.minIndex == 0) {
                    this.findRightmostEdgeAtNode();
                } else {
                    this.findRightmostEdgeAtVertex();
                }
                this.orientedDe = object = this.minDe;
                if (this.getRightmostSide((DirectedEdge)object, this.minIndex) == 1) {
                    this.orientedDe = this.minDe.getSym();
                }
                return;
            }
            object = (DirectedEdge)iterator2.next();
            if (!((DirectedEdge)object).isForward()) continue;
            this.checkForRightmostCoordinate((DirectedEdge)object);
        }
    }

    public Coordinate getCoordinate() {
        return this.minCoord;
    }

    public DirectedEdge getEdge() {
        return this.orientedDe;
    }
}

