/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer.validate;

import com.vividsolutions.jts.algorithm.distance.DiscreteHausdorffDistance;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.PolygonExtracter;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

public class BufferDistanceValidator {
    private static final double MAX_DISTANCE_DIFF_FRAC = 0.012;
    private static boolean VERBOSE = false;
    private double bufDistance;
    private String errMsg = null;
    private Geometry errorIndicator = null;
    private Coordinate errorLocation = null;
    private Geometry input;
    private boolean isValid = true;
    private double maxDistanceFound;
    private double maxValidDistance;
    private double minDistanceFound;
    private double minValidDistance;
    private Geometry result;

    public BufferDistanceValidator(Geometry geometry, double d, Geometry geometry2) {
        this.input = geometry;
        this.bufDistance = d;
        this.result = geometry2;
    }

    private void checkMaximumDistance(Geometry comparable, Geometry coordinateArray, double d) {
        double d2;
        coordinateArray = new DiscreteHausdorffDistance((Geometry)coordinateArray, (Geometry)comparable);
        coordinateArray.setDensifyFraction(0.25);
        this.maxDistanceFound = d2 = coordinateArray.orientedDistance();
        if (d2 > d) {
            this.isValid = false;
            coordinateArray = coordinateArray.getCoordinates();
            this.errorLocation = coordinateArray[1];
            this.errorIndicator = ((Geometry)comparable).getFactory().createLineString(coordinateArray);
            comparable = new StringBuilder("Distance between buffer curve and input is too large (");
            ((StringBuilder)comparable).append(this.maxDistanceFound);
            ((StringBuilder)comparable).append(" at ");
            ((StringBuilder)comparable).append(WKTWriter.toLineString(coordinateArray[0], coordinateArray[1]));
            ((StringBuilder)comparable).append(")");
            this.errMsg = ((StringBuilder)comparable).toString();
        }
    }

    private void checkMinimumDistance(Geometry comparable, Geometry coordinateArray, double d) {
        double d2;
        DistanceOp distanceOp = new DistanceOp((Geometry)comparable, (Geometry)coordinateArray, d);
        this.minDistanceFound = d2 = distanceOp.distance();
        if (d2 < d) {
            this.isValid = false;
            coordinateArray = distanceOp.nearestPoints();
            this.errorLocation = distanceOp.nearestPoints()[1];
            this.errorIndicator = ((Geometry)comparable).getFactory().createLineString(coordinateArray);
            comparable = new StringBuilder("Distance between buffer curve and input is too small (");
            ((StringBuilder)comparable).append(this.minDistanceFound);
            ((StringBuilder)comparable).append(" at ");
            ((StringBuilder)comparable).append(WKTWriter.toLineString(coordinateArray[0], coordinateArray[1]));
            ((StringBuilder)comparable).append(" )");
            this.errMsg = ((StringBuilder)comparable).toString();
        }
    }

    private void checkNegativeValid() {
        Geometry geometry = this.input;
        if (!(geometry instanceof Polygon || geometry instanceof MultiPolygon || geometry instanceof GeometryCollection)) {
            return;
        }
        geometry = this.getPolygonLines(geometry);
        this.checkMinimumDistance(geometry, this.result, this.minValidDistance);
        if (!this.isValid) {
            return;
        }
        this.checkMaximumDistance(geometry, this.result, this.maxValidDistance);
    }

    private void checkPositiveValid() {
        Geometry geometry = this.result.getBoundary();
        this.checkMinimumDistance(this.input, geometry, this.minValidDistance);
        if (!this.isValid) {
            return;
        }
        this.checkMaximumDistance(this.input, geometry, this.maxValidDistance);
    }

    private Geometry getPolygonLines(Geometry geometry) {
        ArrayList arrayList = new ArrayList();
        LinearComponentExtracter linearComponentExtracter = new LinearComponentExtracter(arrayList);
        Iterator iterator2 = PolygonExtracter.getPolygons(geometry).iterator();
        while (iterator2.hasNext()) {
            ((Polygon)iterator2.next()).apply(linearComponentExtracter);
        }
        return geometry.getFactory().buildGeometry(arrayList);
    }

    public Geometry getErrorIndicator() {
        return this.errorIndicator;
    }

    public Coordinate getErrorLocation() {
        return this.errorLocation;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public boolean isValid() {
        double d = Math.abs(this.bufDistance);
        double d2 = 0.012 * d;
        this.minValidDistance = d - d2;
        this.maxValidDistance = d + d2;
        if (!this.input.isEmpty() && !this.result.isEmpty()) {
            if (this.bufDistance > 0.0) {
                this.checkPositiveValid();
            } else {
                this.checkNegativeValid();
            }
            if (VERBOSE) {
                PrintStream printStream = System.out;
                StringBuilder stringBuilder = new StringBuilder("Min Dist= ");
                stringBuilder.append(this.minDistanceFound);
                stringBuilder.append("  err= ");
                stringBuilder.append(1.0 - this.minDistanceFound / this.bufDistance);
                stringBuilder.append("  Max Dist= ");
                stringBuilder.append(this.maxDistanceFound);
                stringBuilder.append("  err= ");
                stringBuilder.append(this.maxDistanceFound / this.bufDistance - 1.0);
                printStream.println(stringBuilder.toString());
            }
            return this.isValid;
        }
        return true;
    }
}

