/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.buffer.validate.BufferDistanceValidator;
import java.io.PrintStream;

public class BufferResultValidator {
    private static final double MAX_ENV_DIFF_FRAC = 0.012;
    private static boolean VERBOSE = false;
    private double distance;
    private Geometry errorIndicator = null;
    private Coordinate errorLocation = null;
    private String errorMsg = null;
    private Geometry input;
    private boolean isValid = true;
    private Geometry result;

    public BufferResultValidator(Geometry geometry, double d, Geometry geometry2) {
        this.input = geometry;
        this.distance = d;
        this.result = geometry2;
    }

    private void checkArea() {
        double d = this.input.getArea();
        double d2 = this.result.getArea();
        double d3 = this.distance;
        if (d3 > 0.0 && d > d2) {
            this.isValid = false;
            this.errorMsg = "Area of positive buffer is smaller than input";
            this.errorIndicator = this.result;
        }
        if (d3 < 0.0 && d < d2) {
            this.isValid = false;
            this.errorMsg = "Area of negative buffer is larger than input";
            this.errorIndicator = this.result;
        }
        this.report("Area");
    }

    private void checkDistance() {
        BufferDistanceValidator bufferDistanceValidator = new BufferDistanceValidator(this.input, this.distance, this.result);
        if (!bufferDistanceValidator.isValid()) {
            this.isValid = false;
            this.errorMsg = bufferDistanceValidator.getErrorMessage();
            this.errorLocation = bufferDistanceValidator.getErrorLocation();
            this.errorIndicator = bufferDistanceValidator.getErrorIndicator();
        }
        this.report("Distance");
    }

    private void checkEnvelope() {
        double d;
        double d2 = this.distance;
        if (d2 < 0.0) {
            return;
        }
        d2 = d = d2 * 0.012;
        if (d == 0.0) {
            d2 = 0.001;
        }
        Envelope envelope = new Envelope(this.input.getEnvelopeInternal());
        envelope.expandBy(this.distance);
        Envelope envelope2 = new Envelope(this.result.getEnvelopeInternal());
        envelope2.expandBy(d2);
        if (!envelope2.contains(envelope)) {
            this.isValid = false;
            this.errorMsg = "Buffer envelope is incorrect";
            this.errorIndicator = this.input.getFactory().toGeometry(envelope2);
        }
        this.report("Envelope");
    }

    private void checkExpectedEmpty() {
        if (this.input.getDimension() >= 2) {
            return;
        }
        if (this.distance > 0.0) {
            return;
        }
        if (!this.result.isEmpty()) {
            this.isValid = false;
            this.errorMsg = "Result is non-empty";
            this.errorIndicator = this.result;
        }
        this.report("ExpectedEmpty");
    }

    private void checkPolygonal() {
        Geometry geometry = this.result;
        if (!(geometry instanceof Polygon) && !(geometry instanceof MultiPolygon)) {
            this.isValid = false;
        }
        this.errorMsg = "Result is not polygonal";
        this.errorIndicator = geometry;
        this.report("Polygonal");
    }

    public static boolean isValid(Geometry geometry, double d, Geometry geometry2) {
        return new BufferResultValidator(geometry, d, geometry2).isValid();
    }

    public static String isValidMsg(Geometry object, double d, Geometry geometry) {
        if (!((BufferResultValidator)(object = new BufferResultValidator((Geometry)object, d, geometry))).isValid()) {
            return ((BufferResultValidator)object).getErrorMessage();
        }
        return null;
    }

    private void report(String string2) {
        if (!VERBOSE) {
            return;
        }
        PrintStream printStream = System.out;
        StringBuilder stringBuilder = new StringBuilder("Check ");
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        string2 = this.isValid ? "passed" : "FAILED";
        stringBuilder.append(string2);
        printStream.println(stringBuilder.toString());
    }

    public Geometry getErrorIndicator() {
        return this.errorIndicator;
    }

    public Coordinate getErrorLocation() {
        return this.errorLocation;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public boolean isValid() {
        this.checkPolygonal();
        boolean bl = this.isValid;
        if (!bl) {
            return bl;
        }
        this.checkExpectedEmpty();
        bl = this.isValid;
        if (!bl) {
            return bl;
        }
        this.checkEnvelope();
        bl = this.isValid;
        if (!bl) {
            return bl;
        }
        this.checkArea();
        bl = this.isValid;
        if (!bl) {
            return bl;
        }
        this.checkDistance();
        return this.isValid;
    }
}

