/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.operation.distance.FacetSequence;
import java.util.ArrayList;
import java.util.List;

public class FacetSequenceTreeBuilder {
    private static final int FACET_SEQUENCE_SIZE = 6;
    private static final int STR_TREE_NODE_CAPACITY = 4;

    private static void addFacetSequences(CoordinateSequence coordinateSequence, List list) {
        int n = coordinateSequence.size();
        int n2 = 0;
        int n3;
        while (n2 <= (n3 = n - 1)) {
            int n4;
            int n5 = n2 + 6;
            int n6 = n4 = n5 + 1;
            if (n4 >= n3) {
                n6 = n;
            }
            list.add(new FacetSequence(coordinateSequence, n2, n6));
            n2 = n5;
        }
        return;
    }

    public static STRtree build(Geometry object) {
        STRtree sTRtree = new STRtree(4);
        object = FacetSequenceTreeBuilder.computeFacetSequences((Geometry)object).iterator();
        while (true) {
            if (!object.hasNext()) {
                sTRtree.build();
                return sTRtree;
            }
            FacetSequence facetSequence = (FacetSequence)object.next();
            sTRtree.insert(facetSequence.getEnvelope(), (Object)facetSequence);
        }
    }

    private static List computeFacetSequences(Geometry geometry) {
        final ArrayList arrayList = new ArrayList();
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry geometry) {
                if (geometry instanceof LineString) {
                    FacetSequenceTreeBuilder.addFacetSequences(((LineString)geometry).getCoordinateSequence(), arrayList);
                } else if (geometry instanceof Point) {
                    FacetSequenceTreeBuilder.addFacetSequences(((Point)geometry).getCoordinateSequence(), arrayList);
                }
            }
        });
        return arrayList;
    }
}

