/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance3d;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;

public class AxisPlaneCoordinateSequence
implements CoordinateSequence {
    private static final int[] XY_INDEX;
    private static final int[] XZ_INDEX;
    private static final int[] YZ_INDEX;
    private int[] indexMap;
    private CoordinateSequence seq;

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        XY_INDEX = nArray;
        nArray = new int[2];
        nArray[1] = 2;
        XZ_INDEX = nArray;
        YZ_INDEX = new int[]{1, 2};
    }

    private AxisPlaneCoordinateSequence(CoordinateSequence coordinateSequence, int[] nArray) {
        this.seq = coordinateSequence;
        this.indexMap = nArray;
    }

    public static CoordinateSequence projectToXY(CoordinateSequence coordinateSequence) {
        return new AxisPlaneCoordinateSequence(coordinateSequence, XY_INDEX);
    }

    public static CoordinateSequence projectToXZ(CoordinateSequence coordinateSequence) {
        return new AxisPlaneCoordinateSequence(coordinateSequence, XZ_INDEX);
    }

    public static CoordinateSequence projectToYZ(CoordinateSequence coordinateSequence) {
        return new AxisPlaneCoordinateSequence(coordinateSequence, YZ_INDEX);
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Envelope expandEnvelope(Envelope envelope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Coordinate getCoordinate(int n) {
        return this.getCoordinateCopy(n);
    }

    @Override
    public void getCoordinate(int n, Coordinate coordinate) {
        coordinate.x = this.getOrdinate(n, 0);
        coordinate.y = this.getOrdinate(n, 1);
        coordinate.z = this.getOrdinate(n, 2);
    }

    @Override
    public Coordinate getCoordinateCopy(int n) {
        return new Coordinate(this.getX(n), this.getY(n), this.getZ(n));
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public double getOrdinate(int n, int n2) {
        if (n2 > 1) {
            return 0.0;
        }
        return this.seq.getOrdinate(n, this.indexMap[n2]);
    }

    @Override
    public double getX(int n) {
        return this.getOrdinate(n, 0);
    }

    @Override
    public double getY(int n) {
        return this.getOrdinate(n, 1);
    }

    public double getZ(int n) {
        return this.getOrdinate(n, 2);
    }

    @Override
    public void setOrdinate(int n, int n2, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.seq.size();
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        throw new UnsupportedOperationException();
    }
}

